/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import android.content.Context;
import com.hjq.http.EasyConfig;
import com.hjq.http.callback.DefaultCallback;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.CallProxy;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.model.UpdateBody;
import com.hjq.http.request.BaseRequest;
import java.io.File;
import java.net.URLEncoder;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public final class PostRequest
extends BaseRequest<PostRequest> {
    private CallProxy mCallProxy;

    public PostRequest(Context context) {
        super(context);
    }

    @Override
    protected Request create(String url, String tag, HttpParams params, HttpHeaders headers) {
        FormBody body;
        MultipartBody.Builder builder;
        Request.Builder request = new Request.Builder();
        request.url(url);
        if (tag != null) {
            request.tag((Object)tag);
        }
        if (!headers.isEmpty()) {
            for (String key : headers.getNames()) {
                request.addHeader(key, headers.get(key));
            }
        }
        if (params.isMultipart()) {
            builder = new MultipartBody.Builder();
            builder.setType(MultipartBody.FORM);
            if (!params.isEmpty()) {
                for (String key : params.getNames()) {
                    Object object = params.get(key);
                    if (object instanceof File) {
                        File file = (File)object;
                        if (!file.exists() || !file.isFile()) continue;
                        builder.addFormDataPart(key, URLEncoder.encode(file.getName()), (RequestBody)new UpdateBody(file));
                        continue;
                    }
                    builder.addFormDataPart(key, object.toString());
                }
            }
            body = builder.build();
        } else {
            builder = new FormBody.Builder();
            if (!params.isEmpty()) {
                for (String key : params.getNames()) {
                    builder.add(key, params.get(key).toString());
                }
            }
            body = builder.build();
        }
        request.post((RequestBody)body);
        return request.build();
    }

    public PostRequest request(OnHttpListener listener) {
        this.mCallProxy = new CallProxy(this.create());
        EasyConfig.getInstance().getHandler().requestStart(this.getContext(), this.mCallProxy);
        this.mCallProxy.enqueue(new DefaultCallback(this.getContext(), this.mCallProxy, listener));
        return this;
    }

    public void cancel() {
        this.mCallProxy.cancel();
    }
}

