/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.callback.BaseCallback;
import com.hjq.http.exception.MD5Exception;
import com.hjq.http.exception.NullBodyException;
import com.hjq.http.listener.OnDownloadListener;
import com.hjq.http.model.CallProxy;
import com.hjq.http.model.DownloadInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class DownloadCallback
extends BaseCallback {
    private DownloadInfo mDownloadInfo;
    private File mFile;
    private String mMD5;
    private OnDownloadListener mListener;

    public DownloadCallback(CallProxy call, File file, String md5, OnDownloadListener listener) {
        super(call);
        this.mDownloadInfo = new DownloadInfo(file);
        this.mFile = file;
        this.mMD5 = md5;
        this.mListener = listener;
    }

    @Override
    protected void onResponse(Response response) throws Exception {
        int readLength;
        if (this.mMD5 == null || "".equals(this.mMD5)) {
            this.mMD5 = response.header("Content-MD5");
        }
        EasyUtils.createFolder(this.mFile.getParentFile());
        EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

            @Override
            public void run() {
                DownloadCallback.this.mListener.onDownloadStart(DownloadCallback.this.mDownloadInfo);
            }
        });
        ResponseBody body = response.body();
        if (body == null) {
            EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

                @Override
                public void run() {
                    DownloadCallback.this.mListener.onDownloadError(DownloadCallback.this.mDownloadInfo, new NullBodyException("The response body is empty"));
                }
            });
            return;
        }
        this.mDownloadInfo.setTotalLength(body.contentLength());
        if (this.mMD5 != null && !"".equals(this.mMD5) && this.mFile.exists() && this.mFile.isFile() && this.mMD5.equalsIgnoreCase(EasyUtils.getFileMD5(this.mFile))) {
            EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

                @Override
                public void run() {
                    DownloadCallback.this.mDownloadInfo.setDownloadLength(DownloadCallback.this.mDownloadInfo.getTotalLength());
                    DownloadCallback.this.mListener.onDownloadComplete(DownloadCallback.this.mDownloadInfo);
                }
            });
            return;
        }
        long downloadSize = 0L;
        byte[] bytes = new byte[8192];
        InputStream inputStream = body.byteStream();
        FileOutputStream outputStream = new FileOutputStream(this.mFile);
        while ((readLength = inputStream.read(bytes)) != -1) {
            outputStream.write(bytes, 0, readLength);
            this.mDownloadInfo.setDownloadLength(downloadSize += (long)readLength);
            EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

                @Override
                public void run() {
                    DownloadCallback.this.mListener.onDownloadProgress(DownloadCallback.this.mDownloadInfo);
                }
            });
            EasyLog.print(this.mFile.getPath() + " \u6b63\u5728\u4e0b\u8f7d" + "\uff0c\u6587\u4ef6\u603b\u5b57\u8282\uff1a" + this.mDownloadInfo.getTotalLength() + "\uff0c\u5df2\u4e0b\u8f7d\u5b57\u8282\uff1a" + this.mDownloadInfo.getDownloadLength() + "\uff0c\u4e0b\u8f7d\u8fdb\u5ea6\uff1a" + this.mDownloadInfo.getDownloadProgress() + " %");
        }
        outputStream.flush();
        EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

            @Override
            public void run() {
                String fileMD5 = EasyUtils.getFileMD5(DownloadCallback.this.mDownloadInfo.getFile());
                if (DownloadCallback.this.mMD5 != null && !"".equals(DownloadCallback.this.mMD5) && !DownloadCallback.this.mMD5.equalsIgnoreCase(fileMD5)) {
                    DownloadCallback.this.onFailure(new MD5Exception("MD5 verify failure", fileMD5));
                } else {
                    DownloadCallback.this.mListener.onDownloadComplete(DownloadCallback.this.mDownloadInfo);
                }
            }
        });
        EasyUtils.closeStream(inputStream);
        EasyUtils.closeStream(outputStream);
    }

    @Override
    protected void onFailure(final Exception e) {
        EasyLog.print(e);
        EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

            @Override
            public void run() {
                DownloadCallback.this.mListener.onDownloadError(DownloadCallback.this.mDownloadInfo, e);
            }
        });
    }
}

