/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import com.hjq.http.EasyConfig;
import com.hjq.http.model.CallProxy;
import java.io.IOException;
import java.net.SocketTimeoutException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public abstract class BaseCallback
implements Callback {
    private CallProxy mCall;
    private int mRetryCount;

    BaseCallback(CallProxy call) {
        this.mCall = call;
    }

    CallProxy getCall() {
        return this.mCall;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response response) {
        try {
            this.onResponse(response);
        }
        catch (Exception e) {
            this.onFailure(e);
        }
        finally {
            response.close();
        }
    }

    public void onFailure(Call call, IOException e) {
        if (e instanceof SocketTimeoutException && this.mRetryCount < EasyConfig.getInstance().getRetryCount()) {
            ++this.mRetryCount;
            Call newCall = call.clone();
            this.mCall.setCall(newCall);
            newCall.enqueue((Callback)this);
            return;
        }
        this.onFailure(e);
    }

    protected abstract void onResponse(Response var1) throws Exception;

    protected abstract void onFailure(Exception var1);
}

