/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import android.content.Context;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.callback.CommonCallback;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.BaseRequest;
import java.io.File;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

public final class PostRequest
extends BaseRequest<PostRequest> {
    public PostRequest(Context context) {
        super(context);
    }

    @Override
    protected Request create(String url, String tag, HttpParams params, HttpHeaders headers) {
        Request.Builder request = new Request.Builder();
        request.url(url);
        if (tag != null) {
            request.tag((Object)tag);
        }
        if (!headers.isEmpty()) {
            for (String key : headers.getNames()) {
                request.addHeader(key, headers.get(key));
            }
        }
        MultipartBody.Builder body = new MultipartBody.Builder();
        body.setType(MultipartBody.FORM);
        if (!params.isEmpty()) {
            for (String key : params.getNames()) {
                String value = params.get(key);
                File file = new File(value);
                if (file.exists() && file.isFile()) {
                    body.addFormDataPart(key, file.getName(), (RequestBody)new UpdateRequestBody(file));
                    continue;
                }
                body.addFormDataPart(key, value);
            }
        }
        request.post((RequestBody)body.build());
        return request.build();
    }

    public void request(OnHttpListener listener) {
        Call call = this.create();
        EasyConfig.getInstance().getHandler().requestStart(this.getContext(), call);
        call.enqueue((Callback)new CommonCallback(this.getContext(), listener));
    }

    private class UpdateRequestBody
    extends RequestBody {
        private File mFile;

        private UpdateRequestBody(File file) {
            this.mFile = file;
        }

        public MediaType contentType() {
            return MediaType.parse((String)"application/octet-stream");
        }

        public long contentLength() {
            return this.mFile.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(BufferedSink sink) throws IOException {
            try (Source source = null;){
                long readCount;
                source = Okio.source((File)this.mFile);
                Buffer buffer = new Buffer();
                long totalSize = this.contentLength();
                long currentSize = 0L;
                while ((readCount = source.read(buffer, 2048L)) != -1L) {
                    sink.write(buffer, readCount);
                    currentSize += readCount;
                    if (!EasyLog.isEnable()) continue;
                    EasyLog.print(this.mFile.getName() + "\u6587\u4ef6\u603b\u5b57\u8282\uff1a" + totalSize + "\uff0c\u5df2\u4e0a\u4f20\u5b57\u8282\uff1a" + currentSize);
                }
            }
        }
    }
}

