/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import android.content.Context;
import com.hjq.http.EasyConfig;
import com.hjq.http.callback.CommonCallback;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.BaseRequest;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.Request;

public final class GetRequest
extends BaseRequest<GetRequest> {
    public GetRequest(Context context) {
        super(context);
    }

    @Override
    protected Request create(String url, String tag, HttpParams params, HttpHeaders headers) {
        Request.Builder request = new Request.Builder();
        if (tag != null) {
            request.tag((Object)tag);
        }
        if (!headers.isEmpty()) {
            for (String key : headers.getNames()) {
                request.addHeader(key, headers.get(key));
            }
        }
        HttpUrl.Builder body = HttpUrl.get((String)url).newBuilder();
        if (!params.isEmpty()) {
            for (String key : params.getNames()) {
                body.addEncodedQueryParameter(key, params.get(key));
            }
        }
        request.get().url(body.build());
        return request.build();
    }

    public void request(OnHttpListener listener) {
        Call call = this.create();
        EasyConfig.getInstance().getHandler().requestStart(this.getContext(), call);
        call.enqueue((Callback)new CommonCallback(this.getContext(), listener));
    }
}

