/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import android.content.Context;
import android.text.TextUtils;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.annotation.HttpHeader;
import com.hjq.http.annotation.HttpIgnore;
import com.hjq.http.annotation.HttpRename;
import com.hjq.http.config.IRequestApi;
import com.hjq.http.config.IRequestHost;
import com.hjq.http.config.IRequestPath;
import com.hjq.http.config.IRequestServer;
import com.hjq.http.config.RequestApi;
import com.hjq.http.config.RequestServer;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import java.lang.reflect.Field;
import java.util.Map;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;

public abstract class BaseRequest<T extends BaseRequest> {
    private OkHttpClient mClient = EasyConfig.getInstance().getClient();
    private IRequestHost mRequestHost = EasyConfig.getInstance().getServer();
    private IRequestPath mRequestPath = EasyConfig.getInstance().getServer();
    private IRequestApi mRequestApi;
    private Context mContext;
    private String mTag;

    public BaseRequest(Context context) {
        this.mContext = context;
    }

    public T api(Class<? extends IRequestApi> api) {
        try {
            return this.api(api.newInstance());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public T api(String api) {
        return this.api(new RequestApi(api));
    }

    public T api(IRequestApi config) {
        this.mRequestApi = config;
        if (config instanceof IRequestServer) {
            this.mRequestHost = (IRequestHost)((Object)config);
            this.mRequestPath = (IRequestPath)((Object)config);
        } else {
            if (config instanceof IRequestHost) {
                this.mRequestHost = (IRequestHost)((Object)config);
            }
            if (config instanceof IRequestPath) {
                this.mRequestPath = (IRequestPath)((Object)config);
            }
        }
        return (T)this;
    }

    public T server(String host) {
        return this.server(new RequestServer(host));
    }

    public T server(IRequestServer server) {
        this.mRequestHost = server;
        this.mRequestPath = server;
        return (T)this;
    }

    public T tag(Object tag) {
        if (tag != null) {
            return this.tag(tag.toString());
        }
        return (T)this;
    }

    public T tag(String tag) {
        this.mTag = tag;
        return (T)this;
    }

    public T client(OkHttpClient client) {
        this.mClient = client;
        return (T)this;
    }

    public Call create() {
        HttpParams params = new HttpParams();
        HttpHeaders headers = new HttpHeaders();
        Field[] fields = this.mRequestApi.getClass().getDeclaredFields();
        for (Field field : fields) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(HttpIgnore.class)) continue;
            try {
                Map map;
                String value;
                Object object = field.get(this.mRequestApi);
                if (object == null || TextUtils.isEmpty((CharSequence)(value = object.toString()))) break;
                String key = field.isAnnotationPresent(HttpRename.class) ? field.getAnnotation(HttpRename.class).value() : field.getName();
                if (field.isAnnotationPresent(HttpHeader.class)) {
                    if (object instanceof Map) {
                        map = (Map)object;
                        for (Object o : map.keySet()) {
                            if (o == null || map.get(o) == null) continue;
                            headers.put(o.toString(), map.get(o).toString());
                        }
                        continue;
                    }
                    headers.put(key, value);
                    continue;
                }
                if (object instanceof Map) {
                    map = (Map)object;
                    for (Object o : map.keySet()) {
                        if (o == null || map.get(o) == null) continue;
                        params.put(o.toString(), map.get(o).toString());
                    }
                    continue;
                }
                params.put(key, value);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        if (EasyLog.isEnable()) {
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
            for (String key : headers.getNames()) {
                EasyLog.print(key, headers.get(key));
            }
            if (!headers.isEmpty() && !params.isEmpty()) {
                EasyLog.print();
            }
            for (String key : params.getNames()) {
                EasyLog.print(key, params.get(key));
            }
            if (!headers.isEmpty() || !params.isEmpty()) {
                EasyLog.print();
            }
        }
        String url = this.mRequestHost.getHost() + this.mRequestPath.getPath() + this.mRequestApi.getApi();
        if (EasyLog.isEnable()) {
            EasyLog.print("RequestUrl\uff1a" + url);
        }
        return this.mClient.newCall(this.create(url, this.mTag, params, headers));
    }

    protected Context getContext() {
        return this.mContext;
    }

    protected abstract Request create(String var1, String var2, HttpParams var3, HttpHeaders var4);
}

