/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.exception.MD5Exception;
import com.hjq.http.listener.OnDownloadListener;
import com.hjq.http.model.DownloadTask;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class DownloadCallback
implements Callback {
    private DownloadTask mDownloadTask;
    private File mFile;
    private String mMD5;
    private OnDownloadListener mListener;

    public DownloadCallback(File file, String md5, OnDownloadListener listener) {
        this.mDownloadTask = new DownloadTask(file);
        this.mFile = file;
        this.mMD5 = md5;
        this.mListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call call, Response response) {
        if (this.mMD5 == null || "".equals(this.mMD5)) {
            this.mMD5 = response.header("Content-MD5");
        }
        EasyUtils.createFolder(this.mFile.getParentFile());
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        byte[] bytes = new byte[8192];
        try {
            EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

                @Override
                public void run() {
                    DownloadCallback.this.mListener.onDownloadStart(DownloadCallback.this.mDownloadTask);
                }
            });
            ResponseBody body = response.body();
            if (body != null) {
                long totalSize = body.contentLength();
                this.mDownloadTask.setTotalBytes(totalSize);
                if (this.mMD5 != null && !"".equals(this.mMD5) && this.mFile.exists() && this.mFile.isFile()) {
                    if (this.mMD5.equalsIgnoreCase(EasyUtils.getFileMD5(this.mFile))) {
                        EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

                            @Override
                            public void run() {
                                DownloadCallback.this.mDownloadTask.setCurrentBytes(DownloadCallback.this.mDownloadTask.getTotalBytes());
                                DownloadCallback.this.mListener.onDownloadProgress(DownloadCallback.this.mDownloadTask);
                                DownloadCallback.this.mListener.onDownloadComplete(DownloadCallback.this.mDownloadTask);
                            }
                        });
                    }
                } else {
                    int length;
                    long downloadSize = 0L;
                    inputStream = body.byteStream();
                    outputStream = new FileOutputStream(this.mFile);
                    while ((length = inputStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, length);
                        this.mDownloadTask.setCurrentBytes(downloadSize += (long)length);
                        if (EasyLog.isEnable()) {
                            EasyLog.print(this.mFile.getPath() + " \u6b63\u5728\u4e0b\u8f7d\uff0c" + "\u6587\u4ef6\u603b\u5b57\u8282\uff1a" + totalSize + "\uff0c\u5df2\u4e0b\u8f7d\u5b57\u8282\uff1a" + downloadSize + ", \u4e0b\u8f7d\u8fdb\u5ea6\uff1a" + this.mDownloadTask.getProgress() + " %");
                        }
                        EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

                            @Override
                            public void run() {
                                DownloadCallback.this.mListener.onDownloadProgress(DownloadCallback.this.mDownloadTask);
                            }
                        });
                    }
                    outputStream.flush();
                    EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

                        @Override
                        public void run() {
                            String fileMD5 = EasyUtils.getFileMD5(DownloadCallback.this.mDownloadTask.getFile());
                            if (DownloadCallback.this.mMD5 != null && !"".equals(DownloadCallback.this.mMD5) && !DownloadCallback.this.mMD5.equalsIgnoreCase(fileMD5)) {
                                DownloadCallback.this.mListener.onDownloadError(DownloadCallback.this.mDownloadTask, new MD5Exception("MD5 verify failure", fileMD5));
                            } else {
                                DownloadCallback.this.mListener.onDownloadComplete(DownloadCallback.this.mDownloadTask);
                            }
                        }
                    });
                }
            }
        }
        catch (IOException e) {
            EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

                @Override
                public void run() {
                    DownloadCallback.this.mListener.onDownloadError(DownloadCallback.this.mDownloadTask, e);
                }
            });
            e.printStackTrace();
        }
        finally {
            EasyUtils.closeStream(inputStream);
            EasyUtils.closeStream(outputStream);
        }
    }

    public void onFailure(Call call, final IOException e) {
        if (EasyLog.isEnable()) {
            e.printStackTrace();
        }
        EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

            @Override
            public void run() {
                DownloadCallback.this.mListener.onDownloadError(DownloadCallback.this.mDownloadTask, e);
            }
        });
    }
}

