/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import android.content.Context;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyUtils;
import com.hjq.http.listener.OnHttpListener;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class CommonCallback
implements Callback {
    private Context mContext;
    private OnHttpListener mListener;

    public CommonCallback(Context context, OnHttpListener listener) {
        this.mContext = context;
        this.mListener = listener;
    }

    public void onResponse(Call call, Response response) {
        try {
            final Object data = EasyConfig.getInstance().getHandler().requestSucceed(this.mContext, call, response, this.mListener);
            EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

                @Override
                public void run() {
                    CommonCallback.this.mListener.onSucceed(data);
                }
            });
            EasyConfig.getInstance().getHandler().requestEnd(this.mContext, call);
        }
        catch (Exception e) {
            this.onFailure(call, EasyConfig.getInstance().getHandler().requestFail(this.mContext, call, e, this.mListener));
        }
    }

    public void onFailure(Call call, IOException e) {
        this.onFailure(call, (Exception)e);
    }

    private void onFailure(Call call, Exception e) {
        final Exception exception = EasyConfig.getInstance().getHandler().requestFail(this.mContext, call, e, this.mListener);
        EasyUtils.runOnUiThread(this.mListener != null, new Runnable(){

            @Override
            public void run() {
                CommonCallback.this.mListener.onFail(exception);
            }
        });
        EasyConfig.getInstance().getHandler().requestEnd(this.mContext, call);
    }
}

