/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http;

import android.os.Handler;
import android.os.Looper;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class EasyUtils {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper());

    public static boolean runOnUiThread(boolean execute, Runnable r) {
        if (execute) {
            return EasyUtils.runOnUiThread(r);
        }
        return false;
    }

    public static boolean runOnUiThread(Runnable r) {
        return HANDLER.post(r);
    }

    public static boolean postDelayed(Runnable r, long delayMillis) {
        return HANDLER.postDelayed(r, delayMillis);
    }

    public static void closeStream(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean createFolder(File targetFolder) {
        if (targetFolder.exists()) {
            if (targetFolder.isDirectory()) {
                return true;
            }
            targetFolder.delete();
        }
        return targetFolder.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileMD5(File file) {
        if (file == null) {
            return null;
        }
        DigestInputStream dis = null;
        try {
            FileInputStream fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            dis = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (dis.read(buffer) > 0) {
            }
            md = dis.getMessageDigest();
            byte[] md5 = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : md5) {
                sb.append(String.format("%02X", b));
            }
            String string = sb.toString().toLowerCase();
            EasyUtils.closeStream(dis);
            return string;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        finally {
            EasyUtils.closeStream(dis);
        }
        return null;
    }
}

