/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http;

import android.util.Log;
import com.hjq.http.EasyConfig;

public final class EasyLog {
    private static final String TAG = "EasyHttp";

    public static boolean isEnable() {
        return EasyConfig.getInstance().isLog();
    }

    public static void print(String log) {
        Log.d((String)TAG, (String)(log != null ? log : "null"));
    }

    public static void print(String key, String value) {
        Log.d((String)TAG, (String)(key + " = " + value));
    }

    public static void print() {
        Log.d((String)TAG, (String)"--------------------");
    }

    public static void json(String json) {
        String text = EasyLog.stringToJSON(json);
        if (text != null && !"".equals(text)) {
            text = " \n" + text;
            int segmentSize = 3072;
            long length = text.length();
            if (length <= (long)segmentSize) {
                Log.d((String)TAG, (String)text);
            } else {
                while (text.length() > segmentSize) {
                    String logContent = text.substring(0, segmentSize);
                    text = text.replace(logContent, "");
                    Log.d((String)TAG, (String)logContent);
                }
                Log.d((String)TAG, (String)text);
            }
        }
    }

    private static String stringToJSON(String strJson) {
        if (strJson == null) {
            return null;
        }
        int tabNum = 0;
        StringBuilder builder = new StringBuilder();
        int length = strJson.length();
        char last = '\u0000';
        for (int i = 0; i < length; ++i) {
            char c = strJson.charAt(i);
            if (c == '{') {
                builder.append(c).append("\n").append(EasyLog.getSpaceOrTab(++tabNum));
            } else if (c == '}') {
                builder.append("\n").append(EasyLog.getSpaceOrTab(--tabNum)).append(c);
            } else if (c == ',') {
                builder.append(c).append("\n").append(EasyLog.getSpaceOrTab(tabNum));
            } else if (c == ':') {
                if (i > 0 && strJson.charAt(i - 1) == '\"') {
                    builder.append(c).append(" ");
                } else {
                    builder.append(c);
                }
            } else if (c == '[') {
                ++tabNum;
                char next = strJson.charAt(i + 1);
                if (next == ']') {
                    builder.append(c);
                } else {
                    builder.append(c).append("\n").append(EasyLog.getSpaceOrTab(tabNum));
                }
            } else if (c == ']') {
                --tabNum;
                if (last == '[') {
                    builder.append(c);
                } else {
                    builder.append("\n").append(EasyLog.getSpaceOrTab(tabNum)).append(c);
                }
            } else {
                builder.append(c);
            }
            last = c;
        }
        return builder.toString();
    }

    private static String getSpaceOrTab(int tabNum) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tabNum; ++i) {
            sb.append('\t');
        }
        return sb.toString();
    }
}

