/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http;

import com.hjq.http.config.IRequestHandler;
import com.hjq.http.config.IRequestServer;
import com.hjq.http.config.RequestServer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import okhttp3.OkHttpClient;

public final class EasyConfig {
    private static volatile EasyConfig sConfig;
    private IRequestServer mServer;
    private IRequestHandler mHandler;
    private boolean mLogEnabled;
    private HashMap<String, String> mParams;
    private HashMap<String, String> mHeaders;
    private OkHttpClient mHttpClient;

    public static EasyConfig getInstance() {
        if (sConfig == null) {
            throw new IllegalStateException("You haven't initialized the configuration yet");
        }
        return sConfig;
    }

    private static void setInstance(EasyConfig config) {
        sConfig = config;
    }

    public static Builder with(OkHttpClient client) {
        return new Builder(client);
    }

    private EasyConfig(Builder builder) {
        this.mServer = builder.mServer;
        this.mHandler = builder.mHandler;
        this.mLogEnabled = builder.mLogEnabled;
        this.mParams = builder.mParams;
        this.mHeaders = builder.mHeaders;
        this.mHttpClient = builder.mClient;
    }

    public boolean isLog() {
        return this.mLogEnabled;
    }

    public IRequestServer getServer() {
        return this.mServer;
    }

    public IRequestHandler getHandler() {
        return this.mHandler;
    }

    public OkHttpClient getClient() {
        return this.mHttpClient;
    }

    public HashMap<String, String> getParams() {
        return this.mParams;
    }

    public HashMap<String, String> getHeaders() {
        return this.mHeaders;
    }

    public void addHeader(String key, String value) {
        this.mHeaders.put(key, value);
    }

    public void addParam(String key, String value) {
        this.mParams.put(key, value);
    }

    public static final class Builder {
        private IRequestServer mServer;
        private IRequestHandler mHandler;
        private OkHttpClient mClient;
        private HashMap<String, String> mParams;
        private HashMap<String, String> mHeaders;
        private boolean mLogEnabled = true;

        public Builder(OkHttpClient client) {
            this.mClient = client;
            this.mParams = new HashMap();
            this.mHeaders = new HashMap();
        }

        public Builder setServer(String host) {
            return this.setServer(new RequestServer(host));
        }

        public Builder setServer(IRequestServer server) {
            this.mServer = server;
            return this;
        }

        public Builder setHandler(IRequestHandler handler) {
            this.mHandler = handler;
            return this;
        }

        public Builder setLog(boolean enabled) {
            this.mLogEnabled = enabled;
            return this;
        }

        public Builder addHeader(String key, String value) {
            this.mHeaders.put(key, value);
            return this;
        }

        public Builder addParam(String key, String value) {
            this.mParams.put(key, value);
            return this;
        }

        public void into() {
            if (this.mClient == null) {
                throw new IllegalArgumentException("The OkHttp client object cannot be empty");
            }
            if (this.mServer == null) {
                throw new IllegalArgumentException("The host configuration cannot be empty");
            }
            try {
                new URL(this.mServer.getHost() + this.mServer.getPath());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("The configured host path url address is not correct");
            }
            if (this.mHandler == null) {
                throw new IllegalArgumentException("The object being processed by the request cannot be empty");
            }
            EasyConfig.setInstance(new EasyConfig(this));
        }
    }
}

