/*
 * Decompiled with CFR 0.152.
 */
package com.serenegiant.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.io.File;
import java.util.ArrayList;

public final class UriHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = UriHelper.class.getSimpleName();
    public static final String[] STANDARD_DIRECTORIES;

    private UriHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getAbsolutePath(@NonNull ContentResolver cr, @Nullable Uri uri) {
        String path;
        block7: {
            path = null;
            if (uri != null) {
                try {
                    String[] columns = new String[]{"_data"};
                    Cursor cursor = cr.query(uri, columns, null, null, null);
                    if (cursor == null) break block7;
                    try {
                        if (cursor.moveToFirst()) {
                            path = cursor.getString(0);
                        }
                    }
                    finally {
                        cursor.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return path;
    }

    public static boolean isStandardDirectory(@NonNull String dir) {
        try {
            for (String valid : STANDARD_DIRECTORIES) {
                if (!valid.equals(dir)) continue;
                return true;
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    @TargetApi(value=19)
    public static String getPath(@NonNull Context context, Uri uri) {
        if (Build.VERSION.SDK_INT >= 19 && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (UriHelper.isExternalStorageDocument(uri)) {
                String[] split;
                String type;
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                if (Build.VERSION.SDK_INT >= 21) {
                    // empty if block
                }
                if ((type = (split = docId.split(":"))[0]) != null) {
                    if ("primary".equalsIgnoreCase(type)) {
                        String path = Environment.getExternalStorageDirectory() + "/";
                        return split.length > 1 ? path + split[1] : path;
                    }
                    if ("home".equalsIgnoreCase(type)) {
                        if (split.length > 1 && UriHelper.isStandardDirectory(split[1])) {
                            return Environment.getExternalStoragePublicDirectory((String)split[1]) + "/";
                        }
                        String path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOCUMENTS) + "/";
                        return split.length > 1 ? path + split[1] : path;
                    }
                    String primary = Environment.getExternalStorageDirectory().getAbsolutePath();
                    File[] dirs = context.getExternalFilesDirs(null);
                    int n = dirs != null ? dirs.length : 0;
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < n; ++i) {
                        String[] dir_elements;
                        int m;
                        String dir_path;
                        File dir = dirs[i];
                        if (dir != null && dir.getAbsolutePath().startsWith(primary)) continue;
                        String string2 = dir_path = dir != null ? dir.getAbsolutePath() : null;
                        if (TextUtils.isEmpty((CharSequence)dir_path) || (m = (dir_elements = dir_path.split("/")).length) <= 2 || !"storage".equalsIgnoreCase(dir_elements[1]) || !type.equalsIgnoreCase(dir_elements[2])) continue;
                        boolean found = false;
                        sb.setLength(0);
                        sb.append('/').append(dir_elements[1]);
                        for (int j = 2; j < m; ++j) {
                            if ("Android".equalsIgnoreCase(dir_elements[j])) {
                                found = true;
                                break;
                            }
                            sb.append('/').append(dir_elements[j]);
                        }
                        if (!found) continue;
                        File path = new File(new File(sb.toString()), split[1]);
                        return path.getAbsolutePath();
                    }
                } else {
                    Log.w((String)TAG, (String)"unexpectedly type is null");
                }
            } else {
                if (UriHelper.isDownloadsDocument(uri)) {
                    String id2 = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.parseLong(id2));
                    return UriHelper.getDataColumn(context, contentUri, null, null);
                }
                if (UriHelper.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    if (contentUri != null) {
                        String selection = "_id=?";
                        String[] selectionArgs = new String[]{split[1]};
                        return UriHelper.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                    }
                }
            }
        } else if (uri != null) {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (UriHelper.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return UriHelper.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        Log.w((String)TAG, (String)("unexpectedly not found,uri=" + uri));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getDataColumn(@NonNull Context context, @NonNull Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static boolean isExternalStorageDocument(@NonNull Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(@NonNull Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(@NonNull Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(@NonNull Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    static {
        ArrayList<String> list = new ArrayList<String>();
        list.add(Environment.DIRECTORY_MUSIC);
        list.add(Environment.DIRECTORY_PODCASTS);
        list.add(Environment.DIRECTORY_RINGTONES);
        list.add(Environment.DIRECTORY_ALARMS);
        list.add(Environment.DIRECTORY_NOTIFICATIONS);
        list.add(Environment.DIRECTORY_PICTURES);
        list.add(Environment.DIRECTORY_MOVIES);
        list.add(Environment.DIRECTORY_DOWNLOADS);
        list.add(Environment.DIRECTORY_DCIM);
        if (Build.VERSION.SDK_INT >= 19) {
            list.add(Environment.DIRECTORY_DOCUMENTS);
        }
        STANDARD_DIRECTORIES = list.toArray(new String[0]);
    }
}

