/*
 * Decompiled with CFR 0.152.
 */
package com.hendraanggrian.support.utils.content;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.provider.MediaStore;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\t\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\n\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\u000b\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\f\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\r\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\u000e\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\u0010\u001a\u00020\b*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u0002*\u00020\u0012\u001a\u0012\u0010\u0011\u001a\u00020\u0002*\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0012\u0010\u0011\u001a\u00020\u0002*\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0001\u00a8\u0006\u0014"}, d2={"getActualPath", "", "Landroid/net/Uri;", "resolver", "Landroid/content/ContentResolver;", "context", "Landroid/content/Context;", "isAsset", "", "isCamera", "isContact", "isContent", "isData", "isFile", "isNetwork", "isQualifiedResource", "isResource", "toUri", "", "packageName", "support-utils_release"})
public final class UrisKt {
    public static final boolean isNetwork(@NotNull Uri $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String it = string = $receiver.getScheme();
        return Intrinsics.areEqual((Object)it, (Object)"https") || Intrinsics.areEqual((Object)it, (Object)"http");
    }

    public static final boolean isFile(@NotNull Uri $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getScheme(), (Object)"file");
    }

    public static final boolean isContent(@NotNull Uri $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getScheme(), (Object)"content");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isContact(@NotNull Uri $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!UrisKt.isContent($receiver)) return false;
        if (!Intrinsics.areEqual((Object)"com.android.contacts", (Object)$receiver.getAuthority())) return false;
        String string = $receiver.getPath();
        String string2 = Uri.withAppendedPath((Uri)ContactsContract.AUTHORITY_URI, (String)"display_photo").getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Uri.withAppendedPath(Con\u2026RI, \"display_photo\").path");
        if (StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isCamera(@NotNull Uri $receiver) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String it = string = $receiver.toString();
        String string2 = MediaStore.Images.Media.EXTERNAL_CONTENT_URI.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"MediaStore.Images.Media.\u2026AL_CONTENT_URI.toString()");
        if (StringsKt.startsWith$default((String)it, (String)string2, (boolean)false, (int)2, null)) return true;
        String string3 = MediaStore.Images.Media.INTERNAL_CONTENT_URI.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"MediaStore.Images.Media.\u2026AL_CONTENT_URI.toString()");
        if (!StringsKt.startsWith$default((String)it, (String)string3, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final boolean isAsset(@NotNull Uri $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getScheme(), (Object)"asset");
    }

    public static final boolean isResource(@NotNull Uri $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getScheme(), (Object)"res");
    }

    public static final boolean isQualifiedResource(@NotNull Uri $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getScheme(), (Object)"android.resource");
    }

    public static final boolean isData(@NotNull Uri $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return Intrinsics.areEqual((Object)$receiver.getScheme(), (Object)"data");
    }

    @Nullable
    public static final String getActualPath(@NotNull Uri $receiver, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        ContentResolver contentResolver = context.getContentResolver();
        Intrinsics.checkExpressionValueIsNotNull((Object)contentResolver, (String)"context.contentResolver");
        return UrisKt.getActualPath($receiver, contentResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final String getActualPath(@NotNull Uri $receiver, @NotNull ContentResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        String result = null;
        if (UrisKt.isContent($receiver)) {
            Cursor cursor = null;
            try {
                cursor = resolver.query($receiver, null, null, null, null);
                if (cursor == null) return result;
                if (!cursor.moveToFirst()) return result;
                int idx = cursor.getColumnIndex("_data");
                if (idx == -1) return result;
                result = cursor.getString(idx);
                return result;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        } else {
            if (!UrisKt.isFile($receiver)) return result;
            return $receiver.getPath();
        }
    }

    @NotNull
    public static final Uri toUri(int $receiver) {
        Uri uri = new Uri.Builder().scheme("res").path(String.valueOf($receiver)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.Builder()\n        .s\u2026tring())\n        .build()");
        return uri;
    }

    @NotNull
    public static final Uri toUri(int $receiver, @NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        String string = context.getPackageName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.packageName");
        return UrisKt.toUri($receiver, string);
    }

    @NotNull
    public static final Uri toUri(int $receiver, @NotNull String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Uri uri = new Uri.Builder().scheme("android.resource").authority(packageName).path(String.valueOf($receiver)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.Builder()\n        .s\u2026tring())\n        .build()");
        return uri;
    }
}

