/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader.errorhandler;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ReadOnlyToken;
import com.helger.css.parser.Token;
import com.helger.css.reader.errorhandler.LoggingCSSParseErrorHandler;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public class CSSParseError {
    private final ReadOnlyToken m_aLastValidToken;
    private final String m_sExpectedTokens;
    private final ReadOnlyToken m_aFirstSkippedToken;
    private final ReadOnlyToken m_aLastSkippedToken;
    private final String m_sErrorMessage;

    public CSSParseError(@Nonempty @NonNull String string) {
        ValueEnforcer.notEmpty((CharSequence)string, (String)"ErrorMsg");
        this.m_aLastValidToken = null;
        this.m_sExpectedTokens = null;
        this.m_aFirstSkippedToken = null;
        this.m_aLastSkippedToken = null;
        this.m_sErrorMessage = string;
    }

    public CSSParseError(@NonNull Token token, @NonNull int[][] nArray, @NonNull String[] stringArray, @Nullable Token token2) {
        ValueEnforcer.notNull((Object)token, (String)"LastValidToken");
        ValueEnforcer.notNull((Object)nArray, (String)"ExpectedTokenSequencesVal");
        ValueEnforcer.notNull((Object)stringArray, (String)"TokenImageVal");
        this.m_aLastValidToken = new ReadOnlyToken(token);
        StringBuilder stringBuilder = new StringBuilder();
        for (int[] nArray2 : nArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            for (int n : nArray2) {
                stringBuilder.append(' ').append(stringArray[n]);
            }
        }
        this.m_sExpectedTokens = stringBuilder.toString();
        this.m_aFirstSkippedToken = new ReadOnlyToken(token.next);
        this.m_aLastSkippedToken = token2 == null ? null : new ReadOnlyToken(token2);
        this.m_sErrorMessage = LoggingCSSParseErrorHandler.createLoggingStringParseError(token, nArray, stringArray, token2);
    }

    public @Nullable ReadOnlyToken getLastValidToken() {
        return this.m_aLastValidToken;
    }

    public @Nullable String getExpectedTokens() {
        return this.m_sExpectedTokens;
    }

    public @Nullable ReadOnlyToken getFirstSkippedToken() {
        return this.m_aFirstSkippedToken;
    }

    public @Nullable ReadOnlyToken getLastSkippedToken() {
        return this.m_aLastSkippedToken;
    }

    @Nonempty
    public @NonNull String getErrorMessage() {
        return this.m_sErrorMessage;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).appendIfNotNull("lastValidToken", (Object)this.m_aLastValidToken).appendIfNotNull("expectedTokens", (Object)this.m_sExpectedTokens).appendIfNotNull("firstSkippedToken", (Object)this.m_aFirstSkippedToken).appendIfNotNull("lastSkippedToken", (Object)this.m_aLastSkippedToken).append("errorMessage", (Object)this.m_sErrorMessage).getToString();
    }

    public static @NonNull CSSParseError createUnexpectedRule(@NonNull Token token, @Nonempty @NonNull String string, @Nonempty @NonNull String string2) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringUnexpectedRule(token, string, string2));
    }

    public static @NonNull CSSParseError createDeprecatedProperty(@NonNull Token token, @NonNull Token token2) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringDeprecatedProperty(token, token2));
    }

    public static @NonNull CSSParseError createBrowserCompliantSkip(@Nullable ParseException parseException, @NonNull Token token, @NonNull Token token2) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringBrowserCompliantSkip(parseException, token, token2));
    }

    public static @NonNull CSSParseError createIllegalCharacter(char c) {
        return new CSSParseError(LoggingCSSParseErrorHandler.createLoggingStringIllegalCharacter(c));
    }
}

