/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.property;

import com.helger.annotation.Nonempty;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.lang.EnumHelper;
import com.helger.base.name.IHasName;
import com.helger.base.string.StringHelper;
import com.helger.collection.helper.CollectionHelperExt;
import com.helger.css.ECSSSpecification;
import com.helger.css.ECSSVendorPrefix;
import java.util.EnumSet;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public enum ECSSProperty implements IHasName
{
    ALIGN_CONTENT("align-content", ECSSSpecification.CSS_FLEXBOX_1, ECSSSpecification.CSS_ALIGN_3),
    ALIGN_ITEMS("align-items", ECSSSpecification.CSS_FLEXBOX_1, ECSSSpecification.CSS_ALIGN_3),
    ALIGN_SELF("align-self", ECSSSpecification.CSS_FLEXBOX_1, ECSSSpecification.CSS_ALIGN_3),
    ALIGNMENT_BASELINE("alignment-baseline", ECSSSpecification.CSS_INLINE_3),
    ALL("all", ECSSSpecification.CSS_CASCADE_3),
    ANIMATION("animation", ECSSSpecification.CSS3_ANIMATIONS),
    ANIMATION_DELAY("animation-delay", ECSSSpecification.CSS3_ANIMATIONS),
    ANIMATION_DIRECTION("animation-direction", ECSSSpecification.CSS3_ANIMATIONS),
    ANIMATION_DURATION("animation-duration", ECSSSpecification.CSS3_ANIMATIONS),
    ANIMATION_FILL_MODE("animation-fill-mode", ECSSSpecification.CSS3_ANIMATIONS),
    ANIMATION_ITERATION_COUNT("animation-iteration-count", ECSSSpecification.CSS3_ANIMATIONS),
    ANIMATION_NAME("animation-name", ECSSSpecification.CSS3_ANIMATIONS),
    ANIMATION_PLAY_STATE("animation-play-state", ECSSSpecification.CSS3_ANIMATIONS),
    ANIMATION_TIMING_FUNCTION("animation-timing-function", ECSSSpecification.CSS3_ANIMATIONS),
    AZIMUTH("azimuth", ECSSSpecification.CSS2),
    BACKFACE_VISIBILITY("backface-visibility", ECSSSpecification.CSS_TRANSFORMS_1),
    BACKGROUND("background", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BACKGROUND_ATTACHMENT("background-attachment", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BACKGROUND_BLEND_MODE("background-blend-mode", ECSSSpecification.COMPOSITING_1),
    BACKGROUND_CLIP("background-clip", ECSSSpecification.CSS3_BACKGROUND),
    BACKGROUND_COLOR("background-color", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BACKGROUND_IMAGE("background-image", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BACKGROUND_ORIGIN("background-origin", ECSSSpecification.CSS3_BACKGROUND),
    BACKGROUND_POSITION("background-position", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BACKGROUND_REPEAT("background-repeat", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BACKGROUND_SIZE("background-size", ECSSSpecification.CSS3_BACKGROUND),
    BASELINE_SHIFT("baseline-shift", ECSSSpecification.CSS_INLINE_3),
    BOOKMARK_LABEL("bookmark-label", ECSSSpecification.CSS_GCPM_3),
    BOOKMARK_LEVEL("bookmark-level", ECSSSpecification.CSS_GCPM_3),
    BOOKMARK_STATE("bookmark-state", ECSSSpecification.CSS_GCPM_3),
    BORDER("border", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_BOTTOM("border-bottom", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_BOTTOM_COLOR("border-bottom-color", ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_BOTTOM_LEFT_RADIUS("border-bottom-left-radius", ECSSSpecification.CSS3_BACKGROUND),
    BORDER_BOTTOM_RIGHT_RADIUS("border-bottom-right-radius", ECSSSpecification.CSS3_BACKGROUND),
    BORDER_BOTTOM_STYLE("border-bottom-style", ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_BOTTOM_WIDTH("border-bottom-width", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_COLLAPSE("border-collapse", ECSSSpecification.CSS2),
    BORDER_COLOR("border-color", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_IMAGE("border-image", ECSSSpecification.CSS3_BACKGROUND),
    BORDER_IMAGE_OUTSET("border-image-outset", ECSSSpecification.CSS3_BACKGROUND),
    BORDER_IMAGE_REPEAT("border-image-repeat", ECSSSpecification.CSS3_BACKGROUND),
    BORDER_IMAGE_SLICE("border-image-slice", ECSSSpecification.CSS3_BACKGROUND),
    BORDER_IMAGE_SOURCE("border-image-source", ECSSSpecification.CSS3_BACKGROUND),
    BORDER_IMAGE_WIDTH("border-image-width", ECSSSpecification.CSS3_BACKGROUND),
    BORDER_LEFT("border-left", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_LEFT_COLOR("border-left-color", ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_LEFT_STYLE("border-left-style", ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_LEFT_WIDTH("border-left-width", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_RADIUS("border-radius", ECSSSpecification.CSS3_BACKGROUND),
    BORDER_RIGHT("border-right", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_RIGHT_COLOR("border-right-color", ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_RIGHT_STYLE("border-right-style", ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_RIGHT_WIDTH("border-right-width", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_SPACING("border-spacing", ECSSSpecification.CSS2),
    BORDER_STYLE("border-style", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_TOP("border-top", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_TOP_COLOR("border-top-color", ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_TOP_LEFT_RADIUS("border-top-left-radius", ECSSSpecification.CSS3_BACKGROUND),
    BORDER_TOP_RIGHT_RADIUS("border-top-right-radius", ECSSSpecification.CSS3_BACKGROUND),
    BORDER_TOP_STYLE("border-top-style", ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_TOP_WIDTH("border-top-width", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BORDER_WIDTH("border-width", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_BACKGROUND),
    BOTTOM("bottom", ECSSSpecification.CSS2, ECSSSpecification.CSS_POSITION_3),
    BOX_DECORATION_BREAK("box-decoration-break", ECSSSpecification.CSS_BREAK_3),
    BOX_SHADOW("box-shadow", ECSSSpecification.CSS3_BACKGROUND),
    BOX_SIZING("box-sizing", ECSSSpecification.CSS_UI_3),
    BOX_SNAP("box-snap", ECSSSpecification.CSS_LINE_GRID_1),
    BOX_SUPPRESS("box-suppress", ECSSSpecification.CSS_DISPLAY_3),
    BREAK_AFTER("break-after", ECSSSpecification.CSS3_MULTICOL, ECSSSpecification.CSS_BREAK_3, ECSSSpecification.CSS_REGIONS_1),
    BREAK_BEFORE("break-before", ECSSSpecification.CSS3_MULTICOL, ECSSSpecification.CSS_BREAK_3, ECSSSpecification.CSS_REGIONS_1),
    BREAK_INSIDE("break-inside", ECSSSpecification.CSS3_MULTICOL, ECSSSpecification.CSS_BREAK_3, ECSSSpecification.CSS_REGIONS_1),
    CAPTION_SIDE("caption-side", ECSSSpecification.CSS2),
    CARET_COLOR("caret-color", ECSSSpecification.CSS_UI_3),
    CHAINS("chains", ECSSSpecification.CSS_TEMPLATE_3),
    CLEAR("clear", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    CLIP("clip", ECSSSpecification.CSS2, ECSSSpecification.CSS_POSITION_3, ECSSSpecification.CSS_MASKING_1),
    CLIP_PATH("clip-path", ECSSSpecification.CSS_MASKING_1),
    CLIP_RULE("clip-rule", ECSSSpecification.CSS_MASKING_1),
    COLOR("color", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS3_COLOR),
    COLOR_INTERPOLATION_FILTERS("color-interpolation-filters", ECSSSpecification.FILTER_EFFECTS_1),
    COLUMNS("columns", ECSSSpecification.CSS3_MULTICOL),
    COLUMNS_SPAN("columns-span", ECSSSpecification.CSS3_MULTICOL),
    COLUMNS_WIDTH("columns-width", ECSSSpecification.CSS3_MULTICOL),
    COLUMN_COUNT("column-count", ECSSSpecification.CSS3_MULTICOL),
    COLUMN_FILL("column-fill", ECSSSpecification.CSS3_MULTICOL),
    COLUMN_GAP("column-gap", ECSSSpecification.CSS3_MULTICOL),
    COLUMN_RULE("column-rule", ECSSSpecification.CSS3_MULTICOL),
    COLUMN_RULE_COLOR("column-rule-color", ECSSSpecification.CSS3_MULTICOL),
    COLUMN_RULE_STYLE("column-rule-style", ECSSSpecification.CSS3_MULTICOL),
    COLUMN_RULE_WIDTH("column-rule-width", ECSSSpecification.CSS3_MULTICOL),
    COLUMN_WIDTH("column-width", ECSSSpecification.CSS3_MULTICOL),
    CONTAIN("contain", ECSSSpecification.CSS_CONTAIN_1),
    CONTENT("content", ECSSSpecification.CSS2, ECSSSpecification.CSS_UI_3),
    COUNTER_INCREMENT("counter-increment", ECSSSpecification.CSS2, ECSSSpecification.CSS_LISTS_3),
    COUNTER_RESET("counter-reset", ECSSSpecification.CSS2, ECSSSpecification.CSS_LISTS_3),
    COUNTER_SET("counter-set", ECSSSpecification.CSS_LISTS_3),
    CUE("cue", ECSSSpecification.CSS2, ECSSSpecification.CSS3_SPEECH),
    CUE_AFTER("cue-after", ECSSSpecification.CSS2, ECSSSpecification.CSS3_SPEECH),
    CUE_BEFORE("cue-before", ECSSSpecification.CSS2, ECSSSpecification.CSS3_SPEECH),
    CURSOR("cursor", ECSSSpecification.CSS2, ECSSSpecification.CSS_UI_3),
    DIRECTION("direction", ECSSSpecification.CSS2, ECSSSpecification.CSS_WRITING_MODES_3),
    DISPLAY("display", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_TEMPLATE_3, ECSSSpecification.CSS_RUBY_1, ECSSSpecification.CSS_DISPLAY_3),
    DISPLAY_INSIDE("display-inside", ECSSSpecification.CSS_DISPLAY_3),
    DISPLAY_LIST("display-list", ECSSSpecification.CSS_DISPLAY_3),
    DISPLAY_OUTSIDE("display-outside", ECSSSpecification.CSS_DISPLAY_3),
    DOMINANT_BASELINE("dominant-baseline", ECSSSpecification.CSS_INLINE_3),
    DROP_INITIAL_AFTER_ADJUST("drop-initial-after-adjust", ECSSSpecification.CSS_INLINE_3),
    DROP_INITIAL_AFTER_ALIGN("drop-initial-after-align", ECSSSpecification.CSS_INLINE_3),
    DROP_INITIAL_BEFORE_ADJUST("drop-initial-before-adjust", ECSSSpecification.CSS_INLINE_3),
    DROP_INITIAL_BEFORE_ALIGN("drop-initial-before-align", ECSSSpecification.CSS_INLINE_3),
    DROP_INITIAL_SIZE("drop-initial-size", ECSSSpecification.CSS_INLINE_3),
    DROP_INITIAL_VALUE("drop-initial-value", ECSSSpecification.CSS_INLINE_3),
    ELEVATION("elevation", ECSSSpecification.CSS2),
    EMPTY_CELLS("empty-cells", ECSSSpecification.CSS2),
    FILTER("filter", ECSSSpecification.FILTER_EFFECTS_1),
    FLEX("flex", ECSSSpecification.CSS_FLEXBOX_1),
    FLEX_BASIS("flex-basis", ECSSSpecification.CSS_FLEXBOX_1),
    FLEX_DIRECTION("flex-direction", ECSSSpecification.CSS_FLEXBOX_1),
    FLEX_FLOW("flex-flow", ECSSSpecification.CSS_FLEXBOX_1),
    FLEX_GROW("flex-grow", ECSSSpecification.CSS_FLEXBOX_1),
    FLEX_SHRINK("flex-shrink", ECSSSpecification.CSS_FLEXBOX_1),
    FLEX_WRAP("flex-wrap", ECSSSpecification.CSS_FLEXBOX_1),
    FLOAT("float", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    FLOOD_COLOR("flood-color", ECSSSpecification.FILTER_EFFECTS_1),
    FLOOD_OPACITY("flood-opactiy", ECSSSpecification.FILTER_EFFECTS_1),
    FLOW_FROM("flow-from", ECSSSpecification.CSS_REGIONS_1),
    FLOW_INTO("flow-into", ECSSSpecification.CSS_REGIONS_1),
    FONT("font", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_FONTS_3),
    FONT_FAMILY("font-family", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_FONTS_3),
    FONT_FEATURE_SETTINGS("font-feature-settings", ECSSSpecification.CSS_FONTS_3),
    FONT_KERNING("font-kerning", ECSSSpecification.CSS_FONTS_3),
    FONT_LANGUAGE_OVERRIDE("font-language-override", ECSSSpecification.CSS_FONTS_3),
    FONT_SIZE("font-size", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_FONTS_3),
    FONT_SIZE_ADJUST("font-size-adjust", ECSSSpecification.CSS_FONTS_3),
    FONT_STRETCH("font-stretch", ECSSSpecification.CSS_FONTS_3),
    FONT_STYLE("font-style", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_FONTS_3),
    FONT_SYNTHESIS("font-synthesis", ECSSSpecification.CSS_FONTS_3),
    FONT_VARIANT("font-variant", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_FONTS_3),
    FONT_VARIANT_ALTERNATES("font-variant-alternates", ECSSSpecification.CSS_FONTS_3),
    FONT_VARIANT_CAPS("font-variant-caps", ECSSSpecification.CSS_FONTS_3),
    FONT_VARIANT_EAST_ASIAN("font-variant-east-asian", ECSSSpecification.CSS_FONTS_3),
    FONT_VARIANT_LIGATURES("font-variant-ligatures", ECSSSpecification.CSS_FONTS_3),
    FONT_VARIANT_NUMERIC("font-variant-numeric", ECSSSpecification.CSS_FONTS_3),
    FONT_VARIANT_POSITION("font-variant-position", ECSSSpecification.CSS_FONTS_3),
    FONT_WEIGHT("font-weight", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_FONTS_3),
    FOOTNOTE_DISPLAY("footnote-display", ECSSSpecification.CSS_GCPM_3),
    FOOTNOTE_POLICY("footnote-policy", ECSSSpecification.CSS_GCPM_3),
    GLYPH_ORIENTATION_VERTICAL("glyph-orientation-vertical", ECSSSpecification.CSS_WRITING_MODES_3),
    GRID("grid", ECSSSpecification.CSS_GRID_1),
    GRID_AREA("grid-area", ECSSSpecification.CSS_GRID_1),
    GRID_AUTO_COLUMNS("grid-auto-columns", ECSSSpecification.CSS_GRID_1),
    GRID_AUTO_FLOW("grid-auto-flow", ECSSSpecification.CSS_GRID_1),
    GRID_AUTO_ROWS("grid-auto-rows", ECSSSpecification.CSS_GRID_1),
    GRID_COLUMN("grid-column", ECSSSpecification.CSS_GRID_1),
    GRID_COLUMN_END("grid-column-end", ECSSSpecification.CSS_GRID_1),
    GRID_COLUMN_START("grid-column-start", ECSSSpecification.CSS_GRID_1),
    GRID_ROW("grid-row", ECSSSpecification.CSS_GRID_1),
    GRID_ROW_END("grid-row-end", ECSSSpecification.CSS_GRID_1),
    GRID_ROW_START("grid-row-start", ECSSSpecification.CSS_GRID_1),
    GRID_TEMPLATE("grid-template", ECSSSpecification.CSS_GRID_1),
    GRID_TEMPLATE_AREAS("grid-template-areas", ECSSSpecification.CSS_GRID_1),
    GRID_TEMPLATE_COLUMNS("grid-template-columns", ECSSSpecification.CSS_GRID_1),
    GRID_TEMPLATE_ROWS("grid-template-rows", ECSSSpecification.CSS_GRID_1),
    HANGING_PUNCTUATION("hanging-punctuation", ECSSSpecification.CSS_TEXT_3),
    HEIGHT("height", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_DEVICE_ADAPT_1),
    HYPHENS("hyphens", ECSSSpecification.CSS_TEXT_3),
    ICON("icon", ECSSSpecification.CSS_UI_3),
    IMAGE_ORIENTATION("image-orientation", ECSSSpecification.CSS3_IMAGES),
    IMAGE_RESOLUTION("image-resolution", ECSSSpecification.CSS3_IMAGES),
    IME_MODE("ime-mode", ECSSSpecification.CSS_UI_3),
    INLINE_BOX_ALIGN("inline-box-align", ECSSSpecification.CSS_INLINE_3),
    ISOLATION("isolation", ECSSSpecification.COMPOSITING_1),
    JUSITFY_CONTENT("justify-content", ECSSSpecification.CSS_FLEXBOX_1, ECSSSpecification.CSS_ALIGN_3),
    JUSITFY_ITEMS("justify-items", ECSSSpecification.CSS_ALIGN_3),
    JUSITFY_SELF("justify-self", ECSSSpecification.CSS_ALIGN_3),
    LEFT("left", ECSSSpecification.CSS2, ECSSSpecification.CSS_POSITION_3),
    LETTER_SPACING("letter-spacing", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_TEXT_3),
    LIGHTING_COLOR("lighting-color", ECSSSpecification.FILTER_EFFECTS_1),
    LINE_BREAK("line-break", ECSSSpecification.CSS_TEXT_3),
    LINE_GRID("line-grid", ECSSSpecification.CSS_LINE_GRID_1),
    LINE_HEIGHT("line-height", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_INLINE_3),
    LINE_SNAP("line-snap", ECSSSpecification.CSS_LINE_GRID_1),
    LINE_STACKING("line-stacking", ECSSSpecification.CSS_INLINE_3),
    LINE_STACKING_RUBY("line-stacking-ruby", ECSSSpecification.CSS_INLINE_3),
    LINE_STACKING_SHIFT("line-stacking-shift", ECSSSpecification.CSS_INLINE_3),
    LINE_STACKING_STRATEGY("line-stacking-strategy", ECSSSpecification.CSS_INLINE_3),
    LIST_STYLE("list-style", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_LISTS_3),
    LIST_STYLE_IMAGE("list-style-image", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_LISTS_3),
    LIST_STYLE_POSITION("list-style-position", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_LISTS_3),
    LIST_STYLE_TYPE("list-style-type", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_LISTS_3),
    MARGIN("margin", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    MARGIN_BOTTOM("margin-bottom", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    MARGIN_LEFT("margin-left", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    MARGIN_RIGHT("margin-right", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    MARGIN_TOP("margin-top", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    MARKER_SIDE("marker-side", ECSSSpecification.CSS_LISTS_3),
    MASK("mask", ECSSSpecification.CSS_MASKING_1),
    MASK_BORDER("mask-border", ECSSSpecification.CSS_MASKING_1),
    MASK_BORDER_MODE("mask-border-mode", ECSSSpecification.CSS_MASKING_1),
    MASK_BORDER_REPEAT("mask-border-repeat", ECSSSpecification.CSS_MASKING_1),
    MASK_BORDER_SLICE("mask-border-slice", ECSSSpecification.CSS_MASKING_1),
    MASK_BORDER_SOURCE("mask-border-source", ECSSSpecification.CSS_MASKING_1),
    MASK_BORDER_WIDTH("mask-border-width", ECSSSpecification.CSS_MASKING_1),
    MASK_CLIP("mask-clip", ECSSSpecification.CSS_MASKING_1),
    MASK_COMPOSITE("mask-composite", ECSSSpecification.CSS_MASKING_1),
    MASK_IMAGE("mask-image", ECSSSpecification.CSS_MASKING_1),
    MASK_MODE("mask-mode", ECSSSpecification.CSS_MASKING_1),
    MASK_ORIGIN("mask-origin", ECSSSpecification.CSS_MASKING_1),
    MASK_POSITION("mask-position", ECSSSpecification.CSS_MASKING_1),
    MASK_REPEAT("mask-repeat", ECSSSpecification.CSS_MASKING_1),
    MASK_SIZE("mask-size", ECSSSpecification.CSS_MASKING_1),
    MASK_TYPE("mask-type", ECSSSpecification.CSS_MASKING_1),
    MAX_HEIGHT("max-height", ECSSSpecification.CSS2, ECSSSpecification.CSS_DEVICE_ADAPT_1),
    MAX_LINES("max-lines", ECSSSpecification.CSS_OVERFLOW_3),
    MAX_WIDTH("max-width", ECSSSpecification.CSS2, ECSSSpecification.CSS_DEVICE_ADAPT_1),
    MAX_ZOOM("max-zoom", ECSSSpecification.CSS_DEVICE_ADAPT_1),
    MIN_HEIGHT("min-height", ECSSSpecification.CSS2, ECSSSpecification.CSS_DEVICE_ADAPT_1),
    MIN_WIDTH("min-width", ECSSSpecification.CSS2, ECSSSpecification.CSS_DEVICE_ADAPT_1),
    MIN_ZOOM("min-zoom", ECSSSpecification.CSS_DEVICE_ADAPT_1),
    MIX_BLEND_MODE("mix-blend-mode", ECSSSpecification.COMPOSITING_1),
    NAV_DOWN("nav-down", ECSSSpecification.CSS_UI_3),
    NAV_INDEX("nav-index", ECSSSpecification.CSS_UI_3),
    NAV_LEFT("nav-left", ECSSSpecification.CSS_UI_3),
    NAV_RIGHT("nav-right", ECSSSpecification.CSS_UI_3),
    NAV_UP("nav-up", ECSSSpecification.CSS_UI_3),
    OBJECT_FIT("object-fit", ECSSSpecification.CSS3_IMAGES),
    OBJECT_POSITION("object-position", ECSSSpecification.CSS3_IMAGES),
    OPACITY("opacity", ECSSSpecification.CSS3_COLOR),
    ORDER("order", ECSSSpecification.CSS_FLEXBOX_1),
    ORIENTATION("orientation", ECSSSpecification.CSS_DEVICE_ADAPT_1),
    ORPHANS("orphans", ECSSSpecification.CSS2, ECSSSpecification.CSS_BREAK_3),
    OUTLINE("outline", ECSSSpecification.CSS2, ECSSSpecification.CSS_UI_3),
    OUTLINE_COLOR("outline-color", ECSSSpecification.CSS2, ECSSSpecification.CSS_UI_3),
    OUTLINE_OFFSET("outline-offset", ECSSSpecification.CSS_UI_3),
    OUTLINE_STYLE("outline-style", ECSSSpecification.CSS2, ECSSSpecification.CSS_UI_3),
    OUTLINE_WIDTH("outline-width", ECSSSpecification.CSS2, ECSSSpecification.CSS_UI_3),
    OVERFLOW("overflow", ECSSSpecification.CSS2, ECSSSpecification.CSS_OVERFLOW_3),
    OVERFLOW_WRAP("overflow-wrap", ECSSSpecification.CSS_TEXT_3),
    OVERFLOW_X("overflow-x", ECSSSpecification.CSS_OVERFLOW_3),
    OVERFLOW_Y("overflow-y", ECSSSpecification.CSS_OVERFLOW_3),
    PADDING("padding", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    PADDING_BOTTOM("padding-bottom", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    PADDING_LEFT("padding-left", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    PADDING_RIGHT("padding-right", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    PADDING_TOP("padding-top", ECSSSpecification.CSS1, ECSSSpecification.CSS2),
    PAGE_BREAK_AFTER("page-break-after", ECSSSpecification.CSS2),
    PAGE_BREAK_BEFORE("page-break-before", ECSSSpecification.CSS2),
    PAGE_BREAK_INSIDE("page-break-inside", ECSSSpecification.CSS2),
    PAUSE("pause", ECSSSpecification.CSS2, ECSSSpecification.CSS3_SPEECH),
    PAUSE_AFTER("pause-after", ECSSSpecification.CSS2, ECSSSpecification.CSS3_SPEECH),
    PAUSE_BEFORE("pause-before", ECSSSpecification.CSS2, ECSSSpecification.CSS3_SPEECH),
    PERSPECTIVE("perspective", ECSSSpecification.CSS_TRANSFORMS_1),
    PERSPECTIVE_ORIGIN("perspective-origin", ECSSSpecification.CSS_TRANSFORMS_1),
    PITCH("pitch", ECSSSpecification.CSS2),
    PITCH_RANGE("pitch-range", ECSSSpecification.CSS2),
    PLAY_DURING("play-during", ECSSSpecification.CSS2),
    POSITION("position", ECSSSpecification.CSS2, ECSSSpecification.CSS_POSITION_3, ECSSSpecification.CSS_TEMPLATE_3),
    QUOTES("quotes", ECSSSpecification.CSS2),
    REGION_FRAGMENT("region-fragment", ECSSSpecification.CSS_REGIONS_1),
    RESIZE("resize", ECSSSpecification.CSS_UI_3),
    RESOLUTION("resolution", ECSSSpecification.CSS_DEVICE_ADAPT_1),
    REST("rest", ECSSSpecification.CSS3_SPEECH),
    REST_AFTER("rest-after", ECSSSpecification.CSS3_SPEECH),
    REST_BEFORE("rest-before", ECSSSpecification.CSS3_SPEECH),
    RICHNESS("richness", ECSSSpecification.CSS2),
    RIGHT("right", ECSSSpecification.CSS2, ECSSSpecification.CSS_POSITION_3),
    RUBY_ALIGN("ruby-align", ECSSSpecification.CSS_RUBY_1),
    RUBY_MERGE("ruby-merge", ECSSSpecification.CSS_RUBY_1),
    RUBY_POSITION("ruby-position", ECSSSpecification.CSS_RUBY_1),
    RUNNING("running", ECSSSpecification.CSS_GCPM_3),
    SCROLL_BEHAVIOR("scroll-behavior", ECSSSpecification.CSSOM_VIEW_1),
    SHAPE_OUTSIDE("shape-outside", ECSSSpecification.CSS_SHAPES_1),
    SHAPE_IMAGE_THRESHOLD("shape-image-threshold", ECSSSpecification.CSS_SHAPES_1),
    SHAPE_MARGIN("shape-margin", ECSSSpecification.CSS_SHAPES_1),
    SIZE("size", ECSSSpecification.CSS3_PAGE),
    SPEAK("speak", ECSSSpecification.CSS2, ECSSSpecification.CSS3_SPEECH),
    SPEAK_AS("speak-as", ECSSSpecification.CSS3_SPEECH),
    SPEAK_HEADER("speak-header", ECSSSpecification.CSS2),
    SPEAK_NUMERAL("speak-numeral", ECSSSpecification.CSS2),
    SPEAK_PUNCTUATION("speak-punctuation", ECSSSpecification.CSS2),
    SPEECH_RATE("speech-rate", ECSSSpecification.CSS2),
    SRC("src", ECSSSpecification.CSS_FONTS_3),
    STRESS("stress", ECSSSpecification.CSS2),
    STRING_SET("string-set", ECSSSpecification.CSS_GCPM_3),
    TABLE_LAYOUT("table-layout", ECSSSpecification.CSS2),
    TAB_SIZE("tab-size", ECSSSpecification.CSS_TEXT_3),
    TEXT_ALIGN("text-align", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_TEXT_3),
    TEXT_ALIGN_LAST("text-align-last", ECSSSpecification.CSS_TEXT_3),
    TEXT_COMBINE_UPRIGHT("text-combine-upright", ECSSSpecification.CSS_WRITING_MODES_3),
    TEXT_DECORATION("text-decoration", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_TEXT_DECOR_3),
    TEXT_DECORATION_COLOR("text-decoration-color", ECSSSpecification.CSS_TEXT_DECOR_3),
    TEXT_DECORATION_LINE("text-decoration-line", ECSSSpecification.CSS_TEXT_DECOR_3),
    TEXT_DECORATION_SKIP("text-decoration-skip", ECSSSpecification.CSS_TEXT_DECOR_3),
    TEXT_DECORATION_STYLE("text-decoration-style", ECSSSpecification.CSS_TEXT_DECOR_3),
    TEXT_EMPHASIS("text-emphasis", ECSSSpecification.CSS_TEXT_DECOR_3),
    TEXT_EMPHASIS_COLOR("text-emphasis-color", ECSSSpecification.CSS_TEXT_DECOR_3),
    TEXT_EMPHASIS_POSITION("text-emphasis-position", ECSSSpecification.CSS_TEXT_DECOR_3),
    TEXT_EMPHASIS_STYLE("text-emphasis-style", ECSSSpecification.CSS_TEXT_DECOR_3),
    TEXT_HEIGHT("text-height", ECSSSpecification.CSS_INLINE_3),
    TEXT_INDENT("text-indent", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_TEXT_3),
    TEXT_JUSTIFY("text-justify", ECSSSpecification.CSS_TEXT_3),
    TEXT_ORIENTATION("text-orientation", ECSSSpecification.CSS_WRITING_MODES_3),
    TEXT_OVERFLOW("text-overflow", ECSSSpecification.CSS_UI_3),
    TEXT_SHADOW("text-shadow", ECSSSpecification.CSS_TEXT_DECOR_3),
    TEXT_TRANSFORM("text-transform", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_TEXT_3),
    TEXT_UNDERLINE_POSITION("text-underline-position", ECSSSpecification.CSS_TEXT_DECOR_3),
    TOP("top", ECSSSpecification.CSS2, ECSSSpecification.CSS_POSITION_3),
    TOUCH_ACTION("touch-action", ECSSSpecification.OUTSIDE_CSS),
    TRANSFORM("transform", ECSSSpecification.CSS_TRANSFORMS_1),
    TRANSFORM_ORIGIN("transform-origin", ECSSSpecification.CSS_TRANSFORMS_1),
    TRANSFORM_STYLE("transform-style", ECSSSpecification.CSS_TRANSFORMS_1),
    TRANSITION("transition", ECSSSpecification.CSS3_TRANSITIONS),
    TRANSITION_DELAY("transition-delay", ECSSSpecification.CSS3_TRANSITIONS),
    TRANSITION_DURATION("transition-duration", ECSSSpecification.CSS3_TRANSITIONS),
    TRANSITION_PROPERTY("transition-property", ECSSSpecification.CSS3_TRANSITIONS),
    TRANSITION_TIMING_FUNCTION("transition-timing-function", ECSSSpecification.CSS3_TRANSITIONS),
    UNICODE_BIDI("unicode-bidi", ECSSSpecification.CSS2, ECSSSpecification.CSS_WRITING_MODES_3),
    UNICODE_RANGE("unicode-range", ECSSSpecification.CSS_FONTS_3),
    USER_ZOOM("user-zoom", ECSSSpecification.CSS_DEVICE_ADAPT_1),
    VERTICAL_ALIGN("vertical-align", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_INLINE_3),
    VISIBILITY("visibility", ECSSSpecification.CSS2),
    VOICE_BALANCE("voice-balance", ECSSSpecification.CSS3_SPEECH),
    VOICE_DURATION("voice-duration", ECSSSpecification.CSS3_SPEECH),
    VOICE_FAMILY("voice-family", ECSSSpecification.CSS2, ECSSSpecification.CSS3_SPEECH),
    VOICE_PITCH("voice-pitch", ECSSSpecification.CSS3_SPEECH),
    VOICE_RANGE("voice-range", ECSSSpecification.CSS3_SPEECH),
    VOICE_RATE("voice-rate", ECSSSpecification.CSS3_SPEECH),
    VOICE_STRESS("voice-stress", ECSSSpecification.CSS3_SPEECH),
    VOICE_VOLUME("voice-volume", ECSSSpecification.CSS3_SPEECH),
    VOLUME("volume", ECSSSpecification.CSS2),
    WHITE_SPACE("white-space", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_TEXT_3),
    WIDOWS("widows", ECSSSpecification.CSS2, ECSSSpecification.CSS_BREAK_3),
    WIDTH("width", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_DEVICE_ADAPT_1),
    WILL_CHANGE("will-change", ECSSSpecification.CSS_WILL_CHANGE_1),
    WORD_BREAK("word-break", ECSSSpecification.CSS_TEXT_3),
    WORD_SPACING("word-spacing", ECSSSpecification.CSS1, ECSSSpecification.CSS2, ECSSSpecification.CSS_TEXT_3),
    WORD_WRAP("word-wrap", ECSSSpecification.CSS_TEXT_3),
    WRAP_FLOW("wrap-flow", ECSSSpecification.CSS3_EXCLUSIONS),
    WRAP_THROUGH("wrap-through", ECSSSpecification.CSS3_EXCLUSIONS),
    WRITING_MODE("writing-mode", ECSSSpecification.CSS_WRITING_MODES_3),
    ZOOM("zoom", ECSSSpecification.CSS_DEVICE_ADAPT_1),
    Z_INDEX("z-index", ECSSSpecification.CSS2, ECSSSpecification.CSS_POSITION_3),
    _MOZ_BACKGROUND_INLINE_POLICY("-moz-background-inline-policy"),
    _MOZ_BINDING("-moz-binding"),
    _MOZ_BORDER_BOTTOM_COLORS("-moz-border-bottom-colors"),
    _MOZ_BORDER_END("-moz-border-end"),
    _MOZ_BORDER_END_COLOR("-moz-border-end-color"),
    _MOZ_BORDER_END_STYLE("-moz-border-end-style"),
    _MOZ_BORDER_END_WIDTH("-moz-border-end-width"),
    _MOZ_BORDER_LEFT_COLORS("-moz-border-left-colors"),
    _MOZ_BORDER_RADIUS_BOTTOMLEFT("-moz-border-radius-bottomleft"),
    _MOZ_BORDER_RADIUS_BOTTOMRIGHT("-moz-border-radius-bottomright"),
    _MOZ_BORDER_RADIUS_TOPLEFT("-moz-border-radius-topleft"),
    _MOZ_BORDER_RADIUS_TOPRIGHT("-moz-border-radius-topright"),
    _MOZ_BORDER_RIGHT_COLORS("-moz-border-right-colors"),
    _MOZ_BORDER_START("-moz-border-start"),
    _MOZ_BORDER_START_COLOR("-moz-border-start-color"),
    _MOZ_BORDER_START_STYLE("-moz-border-start-style"),
    _MOZ_BORDER_START_WIDTH("-moz-border-start-width"),
    _MOZ_BORDER_TOP_COLORS("-moz-border-top-colors"),
    _MOZ_BOX_ALIGN("-moz-box-align"),
    _MOZ_BOX_DIRECTION("-moz-box-direction"),
    _MOZ_BOX_FLEX("-moz-box-flex"),
    _MOZ_BOX_FLEXGROUP("-moz-box-flexgroup"),
    _MOZ_BOX_ORDINAL_GROUP("-moz-box-ordinal-group"),
    _MOZ_BOX_ORIENT("-moz-box-orient"),
    _MOZ_BOX_PACK("-moz-box-pack"),
    _MOZ_FLOAT_EDGE("-moz-float-edge"),
    _MOZ_FORCE_BROKEN_IMAGE_ICON("-moz-force-broken-image-icon"),
    _MOZ_IMAGE_REGION("-moz-image-region"),
    _MOZ_MARGIN_END("-moz-margin-end"),
    _MOZ_MARGIN_START("-moz-margin-start"),
    _MOZ_OUTLINE_RADIUS("-moz-outline-radius"),
    _MOZ_OUTLINE_RADIUS_BOTTOMLEFT("-moz-outline-radius-bottomleft"),
    _MOZ_OUTLINE_RADIUS_BOTTOMRIGHT("-moz-outline-radius-bottomright"),
    _MOZ_OUTLINE_RADIUS_TOPLEFT("-moz-outline-radius-topleft"),
    _MOZ_OUTLINE_RADIUS_TOPRIGHT("-moz-outline-radius-topright"),
    _MOZ_PADDING_END("-moz-padding-end"),
    _MOZ_PADDING_START("-moz-padding-start"),
    _MOZ_STACK_SIZING("-moz-stack-sizing"),
    _MOZ_TEXT_BLINK("-moz-text-blink"),
    _MOZ_USER_FOCUS("-moz-user-focus"),
    _MOZ_USER_INPUT("-moz-user-input"),
    _MOZ_USER_MODIFY("-moz-user-modify"),
    _MOZ_USER_SELECT("-moz-user-select"),
    _MOZ_WINDOW_SHADOW("-moz-window-shadow"),
    _MS_ACCELERATOR("-ms-accelerator"),
    _MS_BACKGROUND_POSITION_X("-ms-background-position-x"),
    _MS_BACKGROUND_POSITION_Y("-ms-background-position-y"),
    _MS_BEHAVIOR("-ms-behavior"),
    _MS_BLOCK_PROGRESSION("-ms-block-progression"),
    _MS_FULLSCREEN("-ms-fullscreen"),
    _MS_INTERPOLATION_MODE("-ms-interpolation-mode"),
    _MS_LAYOUT_FLOW("-ms-layout-flow"),
    _MS_LAYOUT_GRID("-ms-layout-grid"),
    _MS_LAYOUT_GRID_CHAR("-ms-layout-grid-char"),
    _MS_LAYOUT_GRID_LINE("-ms-layout-grid-line"),
    _MS_LAYOUT_GRID_MODE("-ms-layout-grid-mode"),
    _MS_LAYOUT_GRID_TYPE("-ms-layout-grid-type"),
    _MS_LINE_GRID_MODE("-ms-line-grid-mode"),
    _MS_TEXT_AUTOSPACE("-ms-text-autospace"),
    _MS_TEXT_KASHIDA_SPACE("-ms-text-kashida-space"),
    _MS_TEXT_SIZE_ADJUST("-ms-text-size-adjust"),
    _EPUB_TEXT_COMBINE("-epub-text-combine"),
    _WEBKIT_APP_REGION("-webkit-app-region"),
    _WEBKIT_ASPECT_RATIO("-webkit-aspect-ratio"),
    _WEBKIT_BACKGROUND_COMPOSITE("-webkit-background-composite"),
    _WEBKIT_BLEND_MODE("-webkit-blend-mode"),
    _WEBKIT_BORDER_AFTER("-webkit-border-after"),
    _WEBKIT_BORDER_AFTER_COLOR("-webkit-border-after-color"),
    _WEBKIT_BORDER_AFTER_STYLE("-webkit-border-after-style"),
    _WEBKIT_BORDER_AFTER_WIDTH("-webkit-border-after-width"),
    _WEBKIT_BORDER_BEFORE("-webkit-border-before"),
    _WEBKIT_BORDER_BEFORE_COLOR("-webkit-border-before-color"),
    _WEBKIT_BORDER_BEFORE_STYLE("-webkit-border-before-style"),
    _WEBKIT_BORDER_BEFORE_WIDTH("-webkit-border-before-width"),
    _WEBKIT_BORDER_FIT("-webkit-border-fit"),
    _WEBKIT_BORDER_HORIZONTAL_SPACING("-webkit-border-horizontal-spacing"),
    _WEBKIT_BORDER_VERTICAL_SPACING("-webkit-border-vertical-spacing"),
    _WEBKIT_BOX_FLEX_GROUP("-webkit-box-flex-group"),
    _WEBKIT_BOX_LINES("-webkit-box-lines"),
    _WEBKIT_BOX_REFLECT("-webkit-box-reflect"),
    _WEBKIT_COLOR_CORRECTION("-webkit-color-correction"),
    _WEBKIT_COLUMN_AXIS("-webkit-column-axis"),
    _WEBKIT_COLUMN_BREAK_AFTER("-webkit-column-break-after"),
    _WEBKIT_COLUMN_BREAK_BEFORE("-webkit-column-break-before"),
    _WEBKIT_COLUMN_BREAK_INSIDE("-webkit-column-break-inside"),
    _WEBKIT_COLUMN_PROGRESSION("-webkit-column-progression"),
    _WEBKIT_COLUMN_SPAN("-webkit-column-span"),
    _WEBKIT_CURSOR_VISIBILITY("-webkit-cursor-visibility"),
    _WEBKIT_DASHBOARD_REGION("-webkit-dashboard-region"),
    _WEBKIT_FONT_SIZE_DELTA("-webkit-font-size-delta"),
    _WEBKIT_FONT_SMOOTHING("-webkit-font-smoothing"),
    _WEBKIT_GRID_DEFINITION_COLUMNS("-webkit-grid-definition-columns"),
    _WEBKIT_GRID_DEFINITION_ROWS("-webkit-grid-definition-rows"),
    _WEBKIT_HIGHLIGHT("-webkit-highlight"),
    _WEBKIT_HYPHENATE_CHARACTER("-webkit-hyphenate-character"),
    _WEBKIT_HYPHENATE_LIMIT_AFTER("-webkit-hyphenate-limit-after"),
    _WEBKIT_HYPHENATE_LIMIT_BEFORE("-webkit-hyphenate-limit-before"),
    _WEBKIT_HYPHENATE_LIMIT_LINES("-webkit-hyphenate-limit-lines"),
    _WEBKIT_LINE_ALIGN("-webkit-line-align"),
    _WEBKIT_LINE_BOX_CONTAIN("-webkit-line-box-contain"),
    _WEBKIT_LINE_CLAMP("-webkit-line-clamp"),
    _WEBKIT_LOCALE("-webkit-locale"),
    _WEBKIT_LOGICAL_HEIGHT("-webkit-logical-height"),
    _WEBKIT_LOGICAL_WIDTH("-webkit-logical-width"),
    _WEBKIT_MARGIN_AFTER("-webkit-margin-after"),
    _WEBKIT_MARGIN_AFTER_COLLAPSE("-webkit-margin-after-collapse"),
    _WEBKIT_MARGIN_BEFORE("-webkit-margin-before"),
    _WEBKIT_MARGIN_BEFORE_COLLAPSE("-webkit-margin-before-collapse"),
    _WEBKIT_MARGIN_BOTTOM_COLLAPSE("-webkit-margin-bottom-collapse"),
    _WEBKIT_MARGIN_COLLAPSE("-webkit-margin-collapse"),
    _WEBKIT_MARGIN_TOP_COLLAPSE("-webkit-margin-top-collapse"),
    _WEBKIT_MARQUEE("-webkit-marquee"),
    _WEBKIT_MARQUEE_INCREMENT("-webkit-marquee-increment"),
    _WEBKIT_MARQUEE_REPETITION("-webkit-marquee-repetition"),
    _WEBKIT_MASK_POSITION_X("-webkit-mask-position-x"),
    _WEBKIT_MASK_POSITION_Y("-webkit-mask-position-y"),
    _WEBKIT_MASK_REPEAT_X("-webkit-mask-repeat-x"),
    _WEBKIT_MASK_REPEAT_Y("-webkit-mask-repeat-y"),
    _WEBKIT_MAX_LOGICAL_HEIGHT("-webkit-max-logical-height"),
    _WEBKIT_MAX_LOGICAL_WIDTH("-webkit-max-logical-width"),
    _WEBKIT_MIN_LOGICAL_HEIGHT("-webkit-min-logical-height"),
    _WEBKIT_MIN_LOGICAL_WIDTH("-webkit-min-logical-width"),
    _WEBKIT_NBSP_MODE("-webkit-nbsp-mode"),
    _WEBKIT_OVERFLOW_SCROLLING("-webkit-overflow-scrolling"),
    _WEBKIT_PADDING_AFTER("-webkit-padding-after"),
    _WEBKIT_PADDING_BEFORE("-webkit-padding-before"),
    _WEBKIT_PERSPECTIVE_ORIGIN_X("-webkit-perspective-origin-x"),
    _WEBKIT_PERSPECTIVE_ORIGIN_Y("-webkit-perspective-origin-y"),
    _WEBKIT_PRINT_COLOR_ADJUST("-webkit-print-color-adjust"),
    _WEBKIT_REGION_BREAK_AFTER("-webkit-region-break-after"),
    _WEBKIT_REGION_BREAK_BEFORE("-webkit-region-break-before"),
    _WEBKIT_REGION_BREAK_INSIDE("-webkit-region-break-inside"),
    _WEBKIT_RTL_ORDERING("-webkit-rtl-ordering"),
    _WEBKIT_SHAPE_INSIDE("-webkit-shape-inside"),
    _WEBKIT_SHAPE_PADDING("-webkit-shape-padding"),
    _WEBKIT_TAP_HIGHLIGHT_COLOR("-webkit-tap-highlight-color"),
    _WEBKIT_TEXT_DECORATIONS_IN_EFFECT("-webkit-text-decorations-in-effect"),
    _WEBKIT_TEXT_FILL_COLOR("-webkit-text-fill-color"),
    _WEBKIT_TEXT_SECURITY("-webkit-text-security"),
    _WEBKIT_TEXT_STROKE("-webkit-text-stroke"),
    _WEBKIT_TEXT_STROKE_COLOR("-webkit-text-stroke-color"),
    _WEBKIT_TEXT_STROKE_WIDTH("-webkit-text-stroke-width"),
    _WEBKIT_TRANSFORM_ORIGIN_X("-webkit-transform-origin-x"),
    _WEBKIT_TRANSFORM_ORIGIN_Y("-webkit-transform-origin-y"),
    _WEBKIT_TRANSFORM_ORIGIN_Z("-webkit-transform-origin-z"),
    _WEBKIT_USER_DRAG("-webkit-user-drag");

    private final String m_sName;
    private final ECSSVendorPrefix m_eVendorPrefix;
    private final EnumSet<ECSSSpecification> m_aSpecifications;

    private ECSSProperty(String string2) {
        this(string2, null);
    }

    private ECSSProperty(String string2, ECSSSpecification ... eCSSSpecificationArray) {
        this.m_sName = string2;
        ECSSVendorPrefix eCSSVendorPrefix = null;
        for (ECSSVendorPrefix eCSSVendorPrefix2 : ECSSVendorPrefix.values()) {
            if (!string2.startsWith(eCSSVendorPrefix2.getPrefix())) continue;
            eCSSVendorPrefix = eCSSVendorPrefix2;
            break;
        }
        this.m_eVendorPrefix = eCSSVendorPrefix;
        this.m_aSpecifications = CollectionHelperExt.createEnumSet(ECSSSpecification.class, (Enum[])eCSSSpecificationArray);
    }

    @Nonempty
    public @NonNull String getName() {
        return this.m_sName;
    }

    @Nonempty
    public @NonNull String getVendorIndependentName() {
        if (this.m_eVendorPrefix != null) {
            return this.m_sName.substring(this.m_eVendorPrefix.getPrefix().length());
        }
        return this.m_sName;
    }

    @ReturnsMutableCopy
    public @NonNull Set<ECSSSpecification> getAllSpecifications() {
        return EnumSet.copyOf(this.m_aSpecifications);
    }

    public boolean isVendorSpecific(@NonNull ECSSVendorPrefix eCSSVendorPrefix) {
        ValueEnforcer.notNull((Object)((Object)eCSSVendorPrefix), (String)"VendorPrefix");
        return eCSSVendorPrefix.equals((Object)this.m_eVendorPrefix);
    }

    public boolean isVendorSpecific() {
        return this.m_eVendorPrefix != null;
    }

    public @Nullable ECSSVendorPrefix getUsedVendorPrefix() {
        return this.m_eVendorPrefix;
    }

    public static @Nullable ECSSProperty getFromNameOrNull(@Nullable String string) {
        return (ECSSProperty)EnumHelper.getFromNameOrNull(ECSSProperty.class, (String)string);
    }

    public static @Nullable String getPropertyNameHandlingHacks(@Nullable String string) {
        char c;
        String string2 = string;
        if (StringHelper.isNotEmpty((String)string2) && ((c = string2.charAt(0)) == '*' || c == '_' || c == '$')) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    public static @Nullable ECSSProperty getFromNameOrNullHandlingHacks(@Nullable String string) {
        String string2 = ECSSProperty.getPropertyNameHandlingHacks(string);
        return ECSSProperty.getFromNameOrNull(string2);
    }
}

