/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.css.CSSSourceLocation;
import com.helger.css.parser.CSSNode;
import org.jspecify.annotations.NonNull;

public class CSSHandlingException
extends RuntimeException {
    private final CSSNode m_aNode;

    private static @NonNull String _getSourceLocation(@NonNull CSSNode cSSNode) {
        StringBuilder stringBuilder = new StringBuilder();
        CSSSourceLocation cSSSourceLocation = cSSNode.getSourceLocation();
        if (cSSSourceLocation != null) {
            String string = null;
            if (cSSSourceLocation.hasFirstTokenArea()) {
                string = cSSSourceLocation.getFirstTokenLocationAsString();
                stringBuilder.append(string);
            }
            if (cSSSourceLocation.hasLastTokenArea()) {
                String string2 = cSSSourceLocation.getLastTokenLocationAsString();
                if (string == null || !string.equals(string2)) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('-');
                    }
                    stringBuilder.append(string2);
                }
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
        }
        return stringBuilder.toString();
    }

    public CSSHandlingException(@NonNull CSSNode cSSNode, @NonNull String string) {
        super(CSSHandlingException._getSourceLocation(cSSNode) + string);
        this.m_aNode = cSSNode;
    }

    public @NonNull CSSNode getNode() {
        return this.m_aNode;
    }
}

