/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.utils.CSSDataURL;
import com.helger.css.utils.CSSDataURLHelper;
import com.helger.css.utils.CSSURLHelper;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSURI
implements ICSSWriteable,
ICSSSourceLocationAware {
    private String m_sURI;
    private CSSSourceLocation m_aSourceLocation;

    public CSSURI(@NonNull String string) {
        this.setURI(string);
    }

    public final @NonNull String getURI() {
        return this.m_sURI;
    }

    public final @NonNull CSSURI setURI(@NonNull String string) {
        ValueEnforcer.notNull((Object)string, (String)"URI");
        if (CSSURLHelper.isURLValue(string)) {
            throw new IllegalArgumentException("Only the URI and not the CSS-URI value must be passed!");
        }
        this.m_sURI = string;
        return this;
    }

    public boolean isDataURL() {
        return CSSDataURLHelper.isDataURL(this.m_sURI);
    }

    public @Nullable CSSDataURL getAsDataURL() {
        return CSSDataURLHelper.parseDataURL(this.m_sURI);
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return CSSURLHelper.getAsCSSURL(this.m_sURI, iCSSWriterSettings.isQuoteURLs());
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSURI cSSURI = (CSSURI)object;
        return this.m_sURI.equals(cSSURI.m_sURI);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("URI", (Object)this.m_sURI).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

