/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriteable;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.CSSURI;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSImportRule
implements ICSSWriteable,
ICSSSourceLocationAware {
    private CSSURI m_aLocation;
    private final ICommonsList<CSSMediaQuery> m_aMediaQueries = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public CSSImportRule(@NonNull String string) {
        this(new CSSURI(string));
    }

    public CSSImportRule(@NonNull CSSURI cSSURI) {
        this.setLocation(cSSURI);
    }

    public boolean hasMediaQueries() {
        return this.m_aMediaQueries.isNotEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    public @NonNull CSSImportRule addMediaQuery(@NonNull CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.notNull((Object)cSSMediaQuery, (String)"MediaQuery");
        this.m_aMediaQueries.add((Object)cSSMediaQuery);
        return this;
    }

    public @NonNull CSSImportRule addMediaQuery(@Nonnegative int n, @NonNull CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSMediaQuery, (String)"MediaQuery");
        if (n >= this.getMediaQueryCount()) {
            this.m_aMediaQueries.add((Object)cSSMediaQuery);
        } else {
            this.m_aMediaQueries.add(n, (Object)cSSMediaQuery);
        }
        return this;
    }

    public @NonNull EChange removeMediaQuery(@Nullable CSSMediaQuery cSSMediaQuery) {
        return this.m_aMediaQueries.removeObject((Object)cSSMediaQuery);
    }

    public @NonNull EChange removeMediaQuery(int n) {
        return this.m_aMediaQueries.removeAtIndex(n);
    }

    public @NonNull EChange removeAllMediaQueries() {
        return this.m_aMediaQueries.removeAll();
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<CSSMediaQuery> getAllMediaQueries() {
        return (ICommonsList)this.m_aMediaQueries.getClone();
    }

    public final @NonNull CSSURI getLocation() {
        return this.m_aLocation;
    }

    @Nonempty
    public final @NonNull String getLocationString() {
        return this.m_aLocation.getURI();
    }

    public final @NonNull CSSImportRule setLocation(@NonNull CSSURI cSSURI) {
        ValueEnforcer.notNull((Object)cSSURI, (String)"Location");
        this.m_aLocation = cSSURI;
        return this;
    }

    public final @NonNull CSSImportRule setLocationString(@NonNull String string) {
        this.m_aLocation.setURI(string);
        return this;
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("@import ").append(this.m_aLocation.getAsCSSString(iCSSWriterSettings, n));
        if (!this.m_aMediaQueries.isEmpty()) {
            stringBuilder.append(' ');
            boolean bl2 = true;
            for (CSSMediaQuery cSSMediaQuery : this.m_aMediaQueries) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append(bl ? "," : ", ");
                }
                stringBuilder.append(cSSMediaQuery.getAsCSSString(iCSSWriterSettings, n));
            }
        }
        return stringBuilder.append(';').append(iCSSWriterSettings.getNewLineString()).toString();
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSImportRule cSSImportRule = (CSSImportRule)object;
        return this.m_aLocation.equals(cSSImportRule.m_aLocation) && this.m_aMediaQueries.equals(cSSImportRule.m_aMediaQueries);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aLocation).append(this.m_aMediaQueries).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("location", (Object)this.m_aLocation).append("mediaQueries", this.m_aMediaQueries).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

