/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.string.StringImplode;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSExpressionMathMember;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class CSSExpressionMemberMathProduct
implements ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final ICommonsList<ICSSExpressionMathMember> m_aMembers = new CommonsArrayList();
    private CSSSourceLocation m_aSourceLocation;

    public @NonNull CSSExpressionMemberMathProduct addMember(@NonNull ICSSExpressionMathMember iCSSExpressionMathMember) {
        ValueEnforcer.notNull((Object)iCSSExpressionMathMember, (String)"ExpressionMathMember");
        this.m_aMembers.add((Object)iCSSExpressionMathMember);
        return this;
    }

    public @NonNull CSSExpressionMemberMathProduct addMember(@Nonnegative int n, @NonNull ICSSExpressionMathMember iCSSExpressionMathMember) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSExpressionMathMember, (String)"ExpressionMathMember");
        if (n >= this.getMemberCount()) {
            this.m_aMembers.add((Object)iCSSExpressionMathMember);
        } else {
            this.m_aMembers.add(n, (Object)iCSSExpressionMathMember);
        }
        return this;
    }

    public @NonNull EChange removeMember(@NonNull ICSSExpressionMathMember iCSSExpressionMathMember) {
        return this.m_aMembers.removeObject((Object)iCSSExpressionMathMember);
    }

    public @NonNull EChange removeMember(@Nonnegative int n) {
        return this.m_aMembers.removeAtIndex(n);
    }

    public @NonNull EChange removeAllMembers() {
        return this.m_aMembers.removeAll();
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsList<ICSSExpressionMathMember> getAllMembers() {
        return (ICommonsList)this.m_aMembers.getClone();
    }

    @Nonnegative
    public int getMemberCount() {
        return this.m_aMembers.size();
    }

    @Override
    @Nonempty
    public @NonNull String getAsCSSString(@NonNull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return StringImplode.getImplodedMapped(this.m_aMembers, iCSSExpressionMathMember -> iCSSExpressionMathMember.getAsCSSString(iCSSWriterSettings, n));
    }

    @Override
    public final @Nullable CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberMathProduct cSSExpressionMemberMathProduct = (CSSExpressionMemberMathProduct)object;
        return this.m_aMembers.equals(cSSExpressionMemberMathProduct.m_aMembers);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMembers).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("members", this.m_aMembers).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

