/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader;

import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.GuardedBy;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.base.concurrent.SimpleReadWriteLock;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.iface.IHasInputStream;
import com.helger.base.io.nonblocking.NonBlockingStringReader;
import com.helger.base.io.stream.StreamHelper;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.handler.CSSHandler;
import com.helger.css.handler.DoNothingCSSParseExceptionCallback;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.handler.LoggingCSSParseExceptionCallback;
import com.helger.css.parser.CSSCharStream;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CharStream;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ParserCSS30;
import com.helger.css.parser.ParserCSS30TokenManager;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.LoggingCSSInterpretErrorHandler;
import com.helger.css.reader.errorhandler.ThrowingCSSParseErrorHandler;
import com.helger.io.resource.FileSystemResource;
import com.helger.io.resource.IReadableResource;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSReaderDeclarationList {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSReaderDeclarationList.class);
    private static final SimpleReadWriteLock RW_LOCK = new SimpleReadWriteLock();
    @GuardedBy(value="RW_LOCK")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = new ThrowingCSSParseErrorHandler();
    @GuardedBy(value="RW_LOCK")
    private static ICSSParseExceptionCallback s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionCallback();
    @GuardedBy(value="RW_LOCK")
    private static ICSSInterpretErrorHandler s_aDefaultInterpretErrorHandler = new LoggingCSSInterpretErrorHandler();
    private static final CSSReaderDeclarationList INSTANCE = new CSSReaderDeclarationList();

    private CSSReaderDeclarationList() {
    }

    @Nullable
    public static ICSSParseErrorHandler getDefaultParseErrorHandler() {
        return (ICSSParseErrorHandler)RW_LOCK.readLockedGet(() -> s_aDefaultParseErrorHandler);
    }

    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        RW_LOCK.writeLocked(() -> {
            s_aDefaultParseErrorHandler = iCSSParseErrorHandler;
        });
    }

    @Nonnull
    public static ICSSParseExceptionCallback getDefaultParseExceptionHandler() {
        return (ICSSParseExceptionCallback)RW_LOCK.readLockedGet(() -> s_aDefaultParseExceptionHandler);
    }

    public static void setDefaultParseExceptionHandler(@Nonnull ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ValueEnforcer.notNull((Object)iCSSParseExceptionCallback, (String)"DefaultParseExceptionHandler");
        RW_LOCK.writeLocked(() -> {
            s_aDefaultParseExceptionHandler = iCSSParseExceptionCallback;
        });
    }

    @Nonnull
    public static ICSSInterpretErrorHandler getDefaultInterpretErrorHandler() {
        return (ICSSInterpretErrorHandler)RW_LOCK.readLockedGet(() -> s_aDefaultInterpretErrorHandler);
    }

    public static void setDefaultInterpretErrorHandler(@Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        ValueEnforcer.notNull((Object)iCSSInterpretErrorHandler, (String)"DefaultErrorHandler");
        RW_LOCK.writeLocked(() -> {
            s_aDefaultInterpretErrorHandler = iCSSInterpretErrorHandler;
        });
    }

    @Nullable
    private static CSSNode _readStyleDeclaration(@Nonnull CharStream charStream, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nonnull ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ParserCSS30TokenManager parserCSS30TokenManager = new ParserCSS30TokenManager(charStream);
        parserCSS30TokenManager.setCustomErrorHandler(iCSSParseErrorHandler);
        ParserCSS30 parserCSS30 = new ParserCSS30(parserCSS30TokenManager);
        parserCSS30.setCustomErrorHandler(iCSSParseErrorHandler);
        try {
            return parserCSS30.styleDeclarationList();
        }
        catch (ParseException parseException) {
            iCSSParseExceptionCallback.onException(parseException);
            return null;
        }
    }

    public static boolean isValidCSS(@Nonnull File file, @Nonnull Charset charset) {
        return CSSReaderDeclarationList.isValidCSS((IReadableResource)new FileSystemResource(file), charset);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        Reader reader = iReadableResource.getReader(charset);
        if (reader == null) {
            LOGGER.warn("Failed to open CSS reader " + String.valueOf(iReadableResource));
            return false;
        }
        return CSSReaderDeclarationList.isValidCSS(reader);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        return CSSReaderDeclarationList.isValidCSS(StreamHelper.createReader((InputStream)inputStream, (Charset)charset));
    }

    public static boolean isValidCSS(@Nonnull String string) {
        ValueEnforcer.notNull((Object)string, (String)"CSS");
        return CSSReaderDeclarationList.isValidCSS((Reader)new NonBlockingStringReader(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader reader) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            CSSNode cSSNode = CSSReaderDeclarationList._readStyleDeclaration(cSSCharStream, CSSReaderDeclarationList.getDefaultParseErrorHandler(), new DoNothingCSSParseExceptionCallback());
            boolean bl = cSSNode != null;
            return bl;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings());
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromString(string, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromString(string, new CSSReaderSettings().setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromString(string, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), cSSReaderSettings);
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset) {
        return CSSReaderDeclarationList.readFromFile(file, charset, new CSSReaderSettings());
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromFile(file, charset, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromFile(file, charset, new CSSReaderSettings().setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromFile(file, charset, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), cSSReaderSettings);
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull CSSReaderSettings cSSReaderSettings) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(cSSReaderSettings.getFallbackCharset()), cSSReaderSettings);
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset) {
        return CSSReaderDeclarationList.readFromStream(iHasInputStream, charset, new CSSReaderSettings());
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromStream(iHasInputStream, charset, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromStream(iHasInputStream, charset, new CSSReaderSettings().setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromStream(iHasInputStream, charset, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            return null;
        }
        return CSSReaderDeclarationList.readFromStream(inputStream, charset, cSSReaderSettings);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            return null;
        }
        return CSSReaderDeclarationList.readFromStream(inputStream, cSSReaderSettings);
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset) {
        return CSSReaderDeclarationList.readFromStream(inputStream, charset, new CSSReaderSettings());
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromStream(inputStream, charset, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromStream(inputStream, charset, new CSSReaderSettings().setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        return CSSReaderDeclarationList.readFromStream(inputStream, charset, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)inputStream, (Charset)charset), cSSReaderSettings);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)inputStream, (Charset)cSSReaderSettings.getFallbackCharset()), cSSReaderSettings);
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings());
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    @Deprecated(forRemoval=true, since="8.0.0")
    @DevelopersNote(value="Use the version with CSSReaderSettings instead")
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Settings");
        try {
            CSSNode cSSNode;
            ICSSParseExceptionCallback iCSSParseExceptionCallback;
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReaderDeclarationList.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionCallback = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionCallback = CSSReaderDeclarationList.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReaderDeclarationList._readStyleDeclaration(cSSCharStream, iCSSParseErrorHandler, iCSSParseExceptionCallback)) == null) {
                CSSDeclarationList cSSDeclarationList = null;
                return cSSDeclarationList;
            }
            ICSSInterpretErrorHandler iCSSInterpretErrorHandler = cSSReaderSettings.getInterpretErrorHandler();
            if (iCSSInterpretErrorHandler == null) {
                iCSSInterpretErrorHandler = CSSReaderDeclarationList.getDefaultInterpretErrorHandler();
            }
            boolean bl = cSSReaderSettings.isUseSourceLocation();
            CSSDeclarationList cSSDeclarationList = CSSHandler.readDeclarationListFromNode(iCSSInterpretErrorHandler, bl, cSSNode);
            return cSSDeclarationList;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }
}

