/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSSelector;
import com.helger.css.decl.ICSSSelectorMember;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSSelectorMemberHostContext
implements ICSSSelectorMember,
ICSSSourceLocationAware {
    private final CSSSelector m_aSelector;
    private CSSSourceLocation m_aSourceLocation;

    public CSSSelectorMemberHostContext(@Nonnull CSSSelector cSSSelector) {
        ValueEnforcer.notNull((Object)cSSSelector, (String)"SimpleSelector");
        this.m_aSelector = cSSSelector;
    }

    @Nonnull
    public final CSSSelector getSelector() {
        return this.m_aSelector;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder(":host-context(");
        stringBuilder.append(this.m_aSelector.getAsCSSString(iCSSWriterSettings, 0));
        return stringBuilder.append(')').toString();
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSelectorMemberHostContext cSSSelectorMemberHostContext = (CSSSelectorMemberHostContext)object;
        return this.m_aSelector.equals(cSSSelectorMemberHostContext.m_aSelector);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aSelector).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("Selector", (Object)this.m_aSelector).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

