/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSURI;
import com.helger.css.decl.ICSSExpressionMember;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSExpressionMemberTermURI
implements ICSSExpressionMember,
ICSSSourceLocationAware {
    private CSSURI m_aURI;

    public CSSExpressionMemberTermURI(@Nonnull String string) {
        this(new CSSURI(string));
    }

    public CSSExpressionMemberTermURI(@Nonnull CSSURI cSSURI) {
        this.setURI(cSSURI);
    }

    @Nonnull
    public final CSSURI getURI() {
        return this.m_aURI;
    }

    @Nonnull
    @Nonempty
    public final String getURIString() {
        return this.m_aURI.getURI();
    }

    @Nonnull
    public final CSSExpressionMemberTermURI setURI(@Nonnull CSSURI cSSURI) {
        this.m_aURI = (CSSURI)ValueEnforcer.notNull((Object)cSSURI, (String)"URI");
        return this;
    }

    @Nonnull
    public final CSSExpressionMemberTermURI setURIString(@Nonnull String string) {
        this.m_aURI.setURI(string);
        return this;
    }

    @Nonnull
    public CSSExpressionMemberTermURI getClone() {
        return new CSSExpressionMemberTermURI(this.m_aURI);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_aURI.getAsCSSString(iCSSWriterSettings, n);
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aURI.getSourceLocation();
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aURI.setSourceLocation(cSSSourceLocation);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberTermURI cSSExpressionMemberTermURI = (CSSExpressionMemberTermURI)object;
        return this.m_aURI.equals(cSSExpressionMemberTermURI.m_aURI);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_aURI).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("URI", (Object)this.m_aURI).getToString();
    }
}

