/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSUnit;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSExpressionMathMember;
import com.helger.css.utils.CSSNumberHelper;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CSSExpressionMemberMathUnitSimple
implements ICSSExpressionMathMember,
ICSSSourceLocationAware {
    private final String m_sText;
    private final ECSSUnit m_eUnit;
    private CSSSourceLocation m_aSourceLocation;

    public CSSExpressionMemberMathUnitSimple(@Nonnull @Nonempty String string) {
        if (StringHelper.isEmptyAfterTrim((String)string)) {
            throw new IllegalArgumentException("text may not be empty after trimming");
        }
        this.m_sText = string.trim();
        this.m_eUnit = CSSNumberHelper.getMatchingUnitExclPercentage(this.m_sText);
    }

    @Nonnull
    public final String getText() {
        return this.m_sText;
    }

    @Nullable
    public final ECSSUnit getUnit() {
        return this.m_eUnit;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        return this.m_sText;
    }

    @Override
    @Nullable
    public final CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    @Override
    public final void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSExpressionMemberMathUnitSimple cSSExpressionMemberMathUnitSimple = (CSSExpressionMemberMathUnitSimple)object;
        return this.m_sText.equals(cSSExpressionMemberMathUnitSimple.m_sText);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sText).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("text", (Object)this.m_sText).append("unit", (Enum)this.m_eUnit).appendIfNotNull("SourceLocation", (Object)this.m_aSourceLocation).getToString();
    }
}

