/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.parser;

import com.helger.commons.regex.RegExCache;
import com.helger.commons.string.StringHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.RegEx;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSParseHelper {
    public static final char URL_ESCAPE_CHAR = '\\';
    @RegEx
    private static final String SPLIT_NUMBER_REGEX = "^([0-9]*\\.[0-9]+([eE][+-]?[0-9]+)?|[0-9]+([eE][+-]?[0-9]+)?).*$";
    private static final Pattern SPLIT_NUMBER_PATTERN = RegExCache.getPattern((String)"^([0-9]*\\.[0-9]+([eE][+-]?[0-9]+)?|[0-9]+([eE][+-]?[0-9]+)?).*$");
    private static final char[] HEXA_CHARS_UPPER = "0123456789ABCDEF".toCharArray();
    private static final char[] HEXA_CHARS_LOWER = "0123456789abcdef".toCharArray();
    private static final CSSParseHelper INSTANCE = new CSSParseHelper();

    private CSSParseHelper() {
    }

    @Nonnull
    private static String _trimBy(@Nonnull CharSequence charSequence, int n, int n2) {
        return charSequence.toString().substring(n, charSequence.length() - n2);
    }

    @Nonnull
    private static int _parseIntFromReference(@Nonnull String string, int n, int n2, int n3) {
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            int n5 = -1;
            for (int j = 0; j < HEXA_CHARS_UPPER.length; ++j) {
                if (c != HEXA_CHARS_UPPER[j] && c != HEXA_CHARS_LOWER[j]) continue;
                n5 = j;
                break;
            }
            n4 = n3 * n4 + n5;
        }
        return n4;
    }

    @Nullable
    public static String extractStringValue(@Nullable String string) {
        if (StringHelper.hasNoText((String)string) || string.length() < 2) {
            return string;
        }
        char c = string.charAt(0);
        if ((c == '\"' || c == '\'') && StringHelper.getLastChar((CharSequence)string) == c) {
            return CSSParseHelper._trimBy(string, 1, 1);
        }
        return string;
    }

    @Nonnull
    public static String unescapeURL(@Nonnull String string) {
        int n = string.indexOf(92);
        if (n < 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n2 = 0;
        int n3 = 0;
        while (n >= 0) {
            int n4 = -1;
            char c = string.charAt(n + 1);
            switch (c) {
                case '\n': {
                    n4 = -2;
                    n3 = n + 1;
                    break;
                }
                case ' ': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    n4 = c;
                    n3 = n + 1;
                    break;
                }
            }
            if (n4 == -1) {
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') {
                    char c2;
                    int n5;
                    for (n5 = n + 2; n5 < n + 7 && n5 < string.length() && ((c2 = string.charAt(n5)) >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f'); ++n5) {
                    }
                    n4 = CSSParseHelper._parseIntFromReference(string, n + 1, n5, 16);
                    n3 = n5 - 1;
                    if (n5 < string.length() && string.charAt(n5) == ' ') {
                        ++n3;
                    }
                } else {
                    if (c == '\r' || c == '\f') {
                        n = string.indexOf(92, n + 1);
                        continue;
                    }
                    n4 = c;
                    n3 = n + 1;
                }
            }
            stringBuilder.append(string, n2, n);
            n = n3;
            n2 = n + 1;
            if (n4 > 65535) {
                stringBuilder.append(Character.toChars(n4));
            } else if (n4 != -2) {
                stringBuilder.append((char)n4);
            }
            n = string.indexOf(92, n2);
        }
        while (n >= 0) {
        }
        stringBuilder.append(string.substring(n2));
        return stringBuilder.toString();
    }

    @Nonnull
    public static String trimUrl(@Nonnull CharSequence charSequence) {
        String string = CSSParseHelper._trimBy(charSequence, "url(".length(), ")".length()).trim();
        String string2 = CSSParseHelper.extractStringValue(string);
        return CSSParseHelper.unescapeURL(string2);
    }

    @Nonnull
    public static String splitNumber(@Nonnull StringBuilder stringBuilder) {
        Matcher matcher = SPLIT_NUMBER_PATTERN.matcher(stringBuilder);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return "";
    }

    @Nonnull
    public static String validateIdentifier(@Nonnull StringBuilder stringBuilder) {
        char c;
        int n = stringBuilder.length();
        char c2 = stringBuilder.charAt(0);
        char c3 = c = n <= 1 ? (char)'\u0000' : stringBuilder.charAt(1);
        if (c2 == '-' || c2 == '$' || c2 == '*') {
            if (n > 1 && Character.isDigit(c)) {
                throw new IllegalArgumentException("Identifier may not start with a hyphen/dollar/star and a digit: " + String.valueOf(stringBuilder));
            }
        } else if (Character.isDigit(c2)) {
            throw new IllegalArgumentException("Identifier may not start with a digit: " + String.valueOf(stringBuilder));
        }
        return stringBuilder.toString();
    }

    @Nonnull
    public static String unescapeUnicode(StringBuilder stringBuilder) {
        return stringBuilder.toString();
    }

    @Nonnull
    public static String unescapeOther(StringBuilder stringBuilder) {
        return stringBuilder.toString();
    }
}

