/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.utils;

import com.helger.commons.base64.Base64;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.mime.CMimeType;
import com.helger.commons.mime.EMimeQuoting;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeType;
import com.helger.commons.mime.MimeTypeHelper;
import com.helger.commons.mime.MimeTypeParser;
import com.helger.commons.string.StringHelper;
import com.helger.css.utils.CSSDataURL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSDataURLHelper {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.US_ASCII;
    public static final IMimeType DEFAULT_MIME_TYPE = new MimeType(CMimeType.TEXT_PLAIN).addParameter("charset", DEFAULT_CHARSET.name());
    public static final String PREFIX_DATA_URL = "data:";
    public static final String BASE64_MARKER = ";base64";
    public static final char SEPARATOR_CONTENT = ',';
    public static final EMimeQuoting MIME_QUOTING = EMimeQuoting.URL_ESCAPE;
    private static final Logger LOGGER = LoggerFactory.getLogger(CSSDataURLHelper.class);
    private static final CSSDataURLHelper s_aInstance = new CSSDataURLHelper();

    private CSSDataURLHelper() {
    }

    public static boolean isDataURL(@Nullable String string) {
        if (string == null) {
            return false;
        }
        String string2 = string.trim();
        if (string2.length() < PREFIX_DATA_URL.length()) {
            return false;
        }
        return string2.substring(0, PREFIX_DATA_URL.length()).toLowerCase(Locale.ROOT).equals(PREFIX_DATA_URL);
    }

    @Nullable
    public static CSSDataURL parseDataURL(@Nullable String string) {
        String string2;
        IMimeType iMimeType;
        int n;
        boolean bl;
        int n2;
        String string3;
        block15: {
            if (!CSSDataURLHelper.isDataURL(string)) {
                return null;
            }
            string3 = string.trim().substring(PREFIX_DATA_URL.length());
            if (StringHelper.hasNoText((String)string3)) {
                return new CSSDataURL();
            }
            n2 = string3.indexOf(44);
            int n3 = string3.indexOf(BASE64_MARKER);
            bl = false;
            if (n3 >= 0) {
                if (n3 < n2 || n2 < 0) {
                    do {
                        int n4;
                        if ((n4 = string3.indexOf(61, n3)) >= 0 && n4 <= n2 && n2 >= 0) continue;
                        n = n3;
                        bl = true;
                        break block15;
                    } while ((n3 = string3.indexOf(BASE64_MARKER, n3 + BASE64_MARKER.length())) >= 0);
                    n = n2;
                } else {
                    n = n2;
                }
            } else {
                n = n2;
            }
        }
        String string4 = n < 0 ? null : string3.substring(0, n).trim();
        Charset charset = null;
        if (StringHelper.hasNoText((String)string4)) {
            iMimeType = (IMimeType)DEFAULT_MIME_TYPE.getClone();
            charset = DEFAULT_CHARSET;
        } else {
            if (string4.charAt(0) == ';') {
                string4 = DEFAULT_MIME_TYPE.getAsStringWithoutParameters() + string4;
            }
            if ((iMimeType = MimeTypeParser.safeParseMimeType((String)string4, (EMimeQuoting)EMimeQuoting.URL_ESCAPE)) == null) {
                LOGGER.warn("Data URL contains invalid MIME type: '" + string4 + "'");
                return null;
            }
            string2 = MimeTypeHelper.getCharsetNameFromMimeType((IMimeType)iMimeType);
            if (string2 != null && (charset = CharsetHelper.getCharsetFromNameOrNull((String)string2)) == null) {
                LOGGER.warn("Illegal charset '" + string2 + "' contained. Defaulting to '" + DEFAULT_CHARSET.name() + "'");
            }
            if (charset == null) {
                charset = DEFAULT_CHARSET;
            }
        }
        string2 = n2 < 0 ? "" : string3.substring(n2 + 1).trim();
        byte[] byArray = string2.getBytes(charset);
        if (bl) {
            if ((byArray = Base64.safeDecode((byte[])byArray)) == null) {
                LOGGER.warn("Failed to decode Base64 value: " + string2);
                return null;
            }
            string2 = null;
        }
        CSSDataURL cSSDataURL = new CSSDataURL(iMimeType, bl, byArray, charset, string2);
        return cSSDataURL;
    }
}

