/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.reader;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.FileSystemResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.handler.CSSHandler;
import com.helger.css.handler.DoNothingCSSParseExceptionCallback;
import com.helger.css.handler.ICSSParseExceptionCallback;
import com.helger.css.handler.LoggingCSSParseExceptionCallback;
import com.helger.css.parser.CSSCharStream;
import com.helger.css.parser.CSSNode;
import com.helger.css.parser.CharStream;
import com.helger.css.parser.ParseException;
import com.helger.css.parser.ParserCSS30;
import com.helger.css.parser.ParserCSS30TokenManager;
import com.helger.css.reader.CSSReaderSettings;
import com.helger.css.reader.errorhandler.ICSSParseErrorHandler;
import com.helger.css.reader.errorhandler.ThrowingCSSParseErrorHandler;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CSSReaderDeclarationList {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CSSReaderDeclarationList.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseErrorHandler s_aDefaultParseErrorHandler = new ThrowingCSSParseErrorHandler();
    @GuardedBy(value="s_aRWLock")
    private static ICSSParseExceptionCallback s_aDefaultParseExceptionHandler = new LoggingCSSParseExceptionCallback();
    private static final CSSReaderDeclarationList s_aInstance = new CSSReaderDeclarationList();

    private CSSReaderDeclarationList() {
    }

    @Nullable
    public static ICSSParseErrorHandler getDefaultParseErrorHandler() {
        return (ICSSParseErrorHandler)s_aRWLock.readLocked(() -> s_aDefaultParseErrorHandler);
    }

    public static void setDefaultParseErrorHandler(@Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        s_aRWLock.writeLocked(() -> {
            s_aDefaultParseErrorHandler = iCSSParseErrorHandler;
        });
    }

    @Nonnull
    public static ICSSParseExceptionCallback getDefaultParseExceptionHandler() {
        return (ICSSParseExceptionCallback)s_aRWLock.readLocked(() -> s_aDefaultParseExceptionHandler);
    }

    public static void setDefaultParseExceptionHandler(@Nonnull ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ValueEnforcer.notNull((Object)iCSSParseExceptionCallback, (String)"DefaultParseExceptionHandler");
        s_aRWLock.writeLocked(() -> {
            s_aDefaultParseExceptionHandler = iCSSParseExceptionCallback;
        });
    }

    @Nullable
    private static CSSNode _readStyleDeclaration(@Nonnull CharStream charStream, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nonnull ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        switch (eCSSVersion) {
            case CSS21: 
            case CSS30: {
                ParserCSS30TokenManager parserCSS30TokenManager = new ParserCSS30TokenManager(charStream);
                ParserCSS30 parserCSS30 = new ParserCSS30(parserCSS30TokenManager);
                parserCSS30.setCustomErrorHandler(iCSSParseErrorHandler);
                try {
                    return parserCSS30.styleDeclarationList();
                }
                catch (ParseException parseException) {
                    iCSSParseExceptionCallback.onException(parseException);
                    return null;
                }
            }
        }
        throw new IllegalArgumentException("Unsupported CSS version " + (Object)((Object)eCSSVersion));
    }

    public static boolean isValidCSS(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.isValidCSS((IReadableResource)new FileSystemResource(file), charset, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull IReadableResource iReadableResource, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        Reader reader = iReadableResource.getReader(charset);
        if (reader == null) {
            s_aLogger.warn("Failed to open CSS reader " + iReadableResource);
            return false;
        }
        return CSSReaderDeclarationList.isValidCSS(reader, eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        ValueEnforcer.notNull((Object)charset, (String)"Charset");
        return CSSReaderDeclarationList.isValidCSS(StreamHelper.createReader((InputStream)inputStream, (Charset)charset), eCSSVersion);
    }

    public static boolean isValidCSS(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)string, (String)"CSS");
        return CSSReaderDeclarationList.isValidCSS((Reader)new NonBlockingStringReader(string), eCSSVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isValidCSS(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        try {
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            CSSNode cSSNode = CSSReaderDeclarationList._readStyleDeclaration(cSSCharStream, eCSSVersion, CSSReaderDeclarationList.getDefaultParseErrorHandler(), new DoNothingCSSParseExceptionCallback());
            boolean bl = cSSNode != null;
            return bl;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromString(@Nonnull String string, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader((Reader)new NonBlockingStringReader(string), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromFile(@Nonnull File file, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader(new FileSystemResource(file).getReader(charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromStream(iHasInputStream, charset, eCSSVersion, null, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromStream(iHasInputStream, charset, eCSSVersion, iCSSParseErrorHandler, null);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromStream(iHasInputStream, charset, eCSSVersion, null, iCSSParseExceptionCallback);
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull IHasInputStream iHasInputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        InputStream inputStream = iHasInputStream.getInputStream();
        if (inputStream == null) {
            return null;
        }
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)inputStream, (Charset)charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)inputStream, (Charset)charset), new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)inputStream, (Charset)charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)inputStream, (Charset)charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromStream(@Nonnull @WillClose InputStream inputStream, @Nonnull Charset charset, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        return CSSReaderDeclarationList.readFromReader((Reader)StreamHelper.createReader((InputStream)inputStream, (Charset)charset), new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull ECSSVersion eCSSVersion, @Nullable ICSSParseErrorHandler iCSSParseErrorHandler, @Nullable ICSSParseExceptionCallback iCSSParseExceptionCallback) {
        return CSSReaderDeclarationList.readFromReader(reader, new CSSReaderSettings().setCSSVersion(eCSSVersion).setCustomErrorHandler(iCSSParseErrorHandler).setCustomExceptionHandler(iCSSParseExceptionCallback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static CSSDeclarationList readFromReader(@Nonnull @WillClose Reader reader, @Nonnull CSSReaderSettings cSSReaderSettings) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        ValueEnforcer.notNull((Object)cSSReaderSettings, (String)"Settings");
        ECSSVersion eCSSVersion = cSSReaderSettings.getCSSVersion();
        try {
            CSSNode cSSNode;
            ICSSParseExceptionCallback iCSSParseExceptionCallback;
            CSSCharStream cSSCharStream = new CSSCharStream(reader);
            ICSSParseErrorHandler iCSSParseErrorHandler = cSSReaderSettings.getCustomErrorHandler();
            if (iCSSParseErrorHandler == null) {
                iCSSParseErrorHandler = CSSReaderDeclarationList.getDefaultParseErrorHandler();
            }
            if ((iCSSParseExceptionCallback = cSSReaderSettings.getCustomExceptionHandler()) == null) {
                iCSSParseExceptionCallback = CSSReaderDeclarationList.getDefaultParseExceptionHandler();
            }
            if ((cSSNode = CSSReaderDeclarationList._readStyleDeclaration(cSSCharStream, eCSSVersion, iCSSParseErrorHandler, iCSSParseExceptionCallback)) == null) {
                CSSDeclarationList cSSDeclarationList = null;
                return cSSDeclarationList;
            }
            CSSDeclarationList cSSDeclarationList = CSSHandler.readDeclarationListFromNode(eCSSVersion, cSSNode);
            return cSSDeclarationList;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }
}

