/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.propertyvalue;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.property.ECSSProperty;
import com.helger.css.property.ICSSProperty;
import com.helger.css.propertyvalue.CSSValue;
import com.helger.css.propertyvalue.ICSSMultiValue;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CSSValueMultiValue
implements ICSSMultiValue {
    private final List<CSSValue> m_aValues = new ArrayList<CSSValue>();

    public CSSValueMultiValue(@Nonnull ICSSProperty iCSSProperty, @Nonnull @Nonempty String[] stringArray, boolean bl) {
        ValueEnforcer.notNull((Object)iCSSProperty, (String)"Property");
        ValueEnforcer.notEmptyNoNullValue((Object[])stringArray, (String)"Values");
        for (String string : stringArray) {
            this.m_aValues.add(new CSSValue(iCSSProperty, string, bl));
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public List<CSSValue> getAllContainedValues() {
        return CollectionHelper.newList(this.m_aValues);
    }

    @Override
    @Nonnull
    public ECSSProperty getProp() {
        return ((CSSValue)CollectionHelper.getFirstElement(this.m_aValues)).getProp();
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (CSSValue cSSValue : this.m_aValues) {
            stringBuilder.append(cSSValue.getAsCSSString(iCSSWriterSettings, n));
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSValueMultiValue cSSValueMultiValue = (CSSValueMultiValue)object;
        return this.m_aValues.equals(cSSValueMultiValue.m_aValues);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aValues).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("values", this.m_aValues).toString();
    }
}

