/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSTopLevelRule;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSUnknownRule
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final String m_sDeclaration;
    private String m_sParameterList;
    private String m_sBody;
    private CSSSourceLocation m_aSourceLocation;

    public static boolean isValidDeclaration(@Nonnull @Nonempty String string) {
        return StringHelper.startsWith((CharSequence)string, (char)'@');
    }

    public CSSUnknownRule(@Nonnull @Nonempty String string) {
        if (!CSSUnknownRule.isValidDeclaration(string)) {
            throw new IllegalArgumentException("declaration");
        }
        this.m_sDeclaration = string;
    }

    @Nonnull
    @Nonempty
    public String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Nonnull
    public CSSUnknownRule setParameterList(@Nullable String string) {
        this.m_sParameterList = StringHelper.trim((String)string);
        return this;
    }

    @Nullable
    public String getParameterList() {
        return this.m_sParameterList;
    }

    @Nonnull
    public CSSUnknownRule setBody(@Nullable String string) {
        this.m_sBody = StringHelper.trim((String)string);
        return this;
    }

    @Nullable
    public String getBody() {
        return this.m_sBody;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (!iCSSWriterSettings.isWriteUnknownRules()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder(this.m_sDeclaration);
        if (StringHelper.hasText((String)this.m_sParameterList)) {
            stringBuilder.append(' ').append(this.m_sParameterList);
        }
        if (StringHelper.hasNoText((String)this.m_sBody)) {
            stringBuilder.append(bl ? "{}" : " {}\n");
        } else {
            stringBuilder.append(bl ? "{" : " {\n");
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append(this.m_sBody);
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
            if (!bl) {
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSUnknownRule cSSUnknownRule = (CSSUnknownRule)object;
        return this.m_sDeclaration.equals(cSSUnknownRule.m_sDeclaration) && EqualsHelper.equals((Object)this.m_sParameterList, (Object)cSSUnknownRule.m_sParameterList) && EqualsHelper.equals((Object)this.m_sBody, (Object)cSSUnknownRule.m_sBody);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDeclaration).append((Object)this.m_sParameterList).append((Object)this.m_sBody).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declaration", (Object)this.m_sDeclaration).appendIfNotNull("parameterList", (Object)this.m_sParameterList).appendIfNotNull("body", (Object)this.m_sBody).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

