/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotations.Nonempty;
import com.helger.commons.annotations.ReturnsMutableCopy;
import com.helger.commons.collections.ContainerHelper;
import com.helger.commons.hash.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.ICSSTopLevelRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSMediaRule
implements ICSSTopLevelRule,
ICSSSourceLocationAware {
    private final List<CSSMediaQuery> m_aMediaQueries = new ArrayList<CSSMediaQuery>();
    private final List<ICSSTopLevelRule> m_aRules = new ArrayList<ICSSTopLevelRule>();
    private CSSSourceLocation m_aSourceLocation;

    public boolean hasMediaQueries() {
        return !this.m_aMediaQueries.isEmpty();
    }

    @Nonnegative
    public int getMediaQueryCount() {
        return this.m_aMediaQueries.size();
    }

    @Nonnull
    public CSSMediaRule addMediaQuery(@Nonnull @Nonempty CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.notNull((Object)cSSMediaQuery, (String)"MediaQuery");
        this.m_aMediaQueries.add(cSSMediaQuery);
        return this;
    }

    @Nonnull
    public CSSMediaRule addMediaQuery(@Nonnegative int n, @Nonnull @Nonempty CSSMediaQuery cSSMediaQuery) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSMediaQuery, (String)"MediaQuery");
        if (n >= this.getMediaQueryCount()) {
            this.m_aMediaQueries.add(cSSMediaQuery);
        } else {
            this.m_aMediaQueries.add(n, cSSMediaQuery);
        }
        return this;
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnull CSSMediaQuery cSSMediaQuery) {
        return EChange.valueOf((boolean)this.m_aMediaQueries.remove(cSSMediaQuery));
    }

    @Nonnull
    public EChange removeMediaQuery(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMediaQueries.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllMediaQueries() {
        if (this.m_aMediaQueries.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aMediaQueries.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public CSSMediaQuery getMediaQueryAtIndex(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aMediaQueries.size()) {
            return null;
        }
        return this.m_aMediaQueries.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSMediaQuery> getAllMediaQueries() {
        return ContainerHelper.newList(this.m_aMediaQueries);
    }

    public boolean hasRules() {
        return !this.m_aRules.isEmpty();
    }

    @Nonnegative
    public int getRuleCount() {
        return this.m_aRules.size();
    }

    @Nonnull
    public CSSMediaRule addRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.notNull((Object)iCSSTopLevelRule, (String)"Rule");
        this.m_aRules.add(iCSSTopLevelRule);
        return this;
    }

    @Nonnull
    public CSSMediaRule addRule(@Nonnegative int n, @Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)iCSSTopLevelRule, (String)"Rule");
        if (n >= this.getRuleCount()) {
            this.m_aRules.add(iCSSTopLevelRule);
        } else {
            this.m_aRules.add(n, iCSSTopLevelRule);
        }
        return this;
    }

    @Nonnull
    public EChange removeRule(@Nonnull ICSSTopLevelRule iCSSTopLevelRule) {
        return EChange.valueOf((boolean)this.m_aRules.remove(iCSSTopLevelRule));
    }

    @Nonnull
    public EChange removeRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aRules.size()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.remove(n);
        return EChange.CHANGED;
    }

    @Nonnull
    public EChange removeAllRules() {
        if (this.m_aRules.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aRules.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public ICSSTopLevelRule getRule(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aRules.size()) {
            return null;
        }
        return this.m_aRules.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<ICSSTopLevelRule> getAllRules() {
        return ContainerHelper.newList(this.m_aRules);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        if (!iCSSWriterSettings.isWriteMediaRules()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        int n2 = this.m_aRules.size();
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && n2 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("@media ");
        boolean bl2 = true;
        for (CSSMediaQuery iCSSWriteable : this.m_aMediaQueries) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(bl ? "," : ", ");
            }
            stringBuilder.append(iCSSWriteable.getAsCSSString(iCSSWriterSettings, n));
        }
        if (n2 == 0) {
            stringBuilder.append(bl ? "{}" : " {}\n");
        } else {
            stringBuilder.append(bl ? "{" : " {\n");
            bl2 = true;
            for (ICSSTopLevelRule iCSSTopLevelRule : this.m_aRules) {
                String string = iCSSTopLevelRule.getAsCSSString(iCSSWriterSettings, n + 1);
                if (!StringHelper.hasText((String)string)) continue;
                if (bl2) {
                    bl2 = false;
                } else if (!bl) {
                    stringBuilder.append('\n');
                }
                if (!bl) {
                    stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
                }
                stringBuilder.append(string);
            }
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n));
            }
            stringBuilder.append('}');
            if (!bl) {
                stringBuilder.append('\n');
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSMediaRule cSSMediaRule = (CSSMediaRule)object;
        return this.m_aMediaQueries.equals(cSSMediaRule.m_aMediaQueries) && this.m_aRules.equals(cSSMediaRule.m_aRules);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMediaQueries).append(this.m_aRules).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("mediaQueries", this.m_aMediaQueries).append("styleRules", this.m_aRules).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

