/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.annotations.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.commons.name.IHasName;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.ICSSSelectorMember;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum ECSSSelectorCombinator implements ICSSSelectorMember,
ICSSVersionAware,
IHasName
{
    PLUS("+"),
    GREATER(">"),
    TILDE("~", ECSSVersion.CSS30),
    BLANK(" ");

    private final String m_sName;
    private final ECSSVersion m_eVersion;

    private ECSSSelectorCombinator(String string2) {
        this(string2, ECSSVersion.CSS21);
    }

    private ECSSSelectorCombinator(String string2, ECSSVersion eCSSVersion) {
        this.m_sName = string2;
        this.m_eVersion = eCSSVersion;
    }

    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Override
    @Nonnull
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        return this.m_sName;
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return this.m_eVersion;
    }

    @Nullable
    public static ECSSSelectorCombinator getFromNameOrNull(@Nullable String string) {
        return (ECSSSelectorCombinator)EnumHelper.getFromNameOrNull(ECSSSelectorCombinator.class, (String)string);
    }
}

