/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.xpath;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.clone.ICloneable;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.equals.EqualsHelper;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.state.EChange;
import com.helger.base.state.IChangeIndicator;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.xml.xpath.XPathFunctionKey;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionResolver;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@NotThreadSafe
public class MapBasedXPathFunctionResolver
implements XPathFunctionResolver,
ICloneable<MapBasedXPathFunctionResolver> {
    private final ICommonsOrderedMap<XPathFunctionKey, XPathFunction> m_aMap;

    public MapBasedXPathFunctionResolver() {
        this.m_aMap = new CommonsLinkedHashMap();
    }

    public MapBasedXPathFunctionResolver(@NonNull MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver) {
        ValueEnforcer.notNull((Object)mapBasedXPathFunctionResolver, (String)"Other");
        this.m_aMap = mapBasedXPathFunctionResolver.m_aMap.getClone();
    }

    public @NonNull EChange addUniqueFunction(@NonNull String string, @NonNull String string2, @Nonnegative int n, @NonNull XPathFunction xPathFunction) {
        return this.addUniqueFunction(new QName(string, string2), n, xPathFunction);
    }

    public @NonNull EChange addUniqueFunction(@NonNull QName qName, @Nonnegative int n, @NonNull XPathFunction xPathFunction) {
        ValueEnforcer.notNull((Object)xPathFunction, (String)"Function");
        XPathFunctionKey xPathFunctionKey = new XPathFunctionKey(qName, n);
        if (this.m_aMap.containsKey((Object)xPathFunctionKey)) {
            return EChange.UNCHANGED;
        }
        this.m_aMap.put((Object)xPathFunctionKey, (Object)xPathFunction);
        return EChange.CHANGED;
    }

    public @NonNull EChange addAllFrom(@NonNull MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver, boolean bl) {
        ValueEnforcer.notNull((Object)mapBasedXPathFunctionResolver, (String)"Other");
        EChange eChange = EChange.UNCHANGED;
        for (Map.Entry entry : mapBasedXPathFunctionResolver.m_aMap.entrySet()) {
            if (!bl && this.m_aMap.containsKey(entry.getKey())) continue;
            this.m_aMap.put((Object)((XPathFunctionKey)entry.getKey()), (Object)((XPathFunction)entry.getValue()));
            eChange = EChange.CHANGED;
        }
        return eChange;
    }

    public @NonNull EChange removeFunction(@NonNull QName qName, @Nonnegative int n) {
        XPathFunctionKey xPathFunctionKey = new XPathFunctionKey(qName, n);
        return this.removeFunction(xPathFunctionKey);
    }

    public @NonNull EChange removeFunction(@Nullable XPathFunctionKey xPathFunctionKey) {
        if (xPathFunctionKey == null) {
            return EChange.UNCHANGED;
        }
        return this.m_aMap.removeObject((Object)xPathFunctionKey);
    }

    public @NonNull EChange removeFunctionsWithName(@Nullable QName qName) {
        EChange eChange = EChange.UNCHANGED;
        if (qName != null) {
            for (XPathFunctionKey xPathFunctionKey : this.m_aMap.copyOfKeySet()) {
                if (!xPathFunctionKey.getFunctionName().equals(qName)) continue;
                eChange = eChange.or((IChangeIndicator)this.removeFunction(xPathFunctionKey));
            }
        }
        return eChange;
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsOrderedMap<XPathFunctionKey, XPathFunction> getAllFunctions() {
        return this.m_aMap.getClone();
    }

    @Nonnegative
    public int getFunctionCount() {
        return this.m_aMap.size();
    }

    public @NonNull EChange clear() {
        return this.m_aMap.removeAll();
    }

    @Override
    public @Nullable XPathFunction resolveFunction(@NonNull QName qName, @Nonnegative int n) {
        return this.resolveFunction(new XPathFunctionKey(qName, n));
    }

    public @Nullable XPathFunction resolveFunction(@Nullable XPathFunctionKey xPathFunctionKey) {
        return (XPathFunction)this.m_aMap.get((Object)xPathFunctionKey);
    }

    @ReturnsMutableCopy
    public @NonNull MapBasedXPathFunctionResolver getClone() {
        return new MapBasedXPathFunctionResolver(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedXPathFunctionResolver mapBasedXPathFunctionResolver = (MapBasedXPathFunctionResolver)object;
        return EqualsHelper.equals(this.m_aMap, mapBasedXPathFunctionResolver.m_aMap);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aMap).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("map", this.m_aMap).getToString();
    }
}

