/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.resourcebundle;

import com.helger.annotation.WillClose;
import com.helger.annotation.WillNotClose;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.misc.DevelopersNote;
import com.helger.annotation.style.CodingStyleguideUnaware;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.collection.commons.CommonsLinkedHashMap;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.commons.ICommonsOrderedMap;
import com.helger.collection.enumeration.EnumerationHelper;
import com.helger.xml.microdom.IMicroDocument;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroDocument;
import com.helger.xml.microdom.serialize.MicroReader;
import com.helger.xml.resourcebundle.XMLResourceBundleControl;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Immutable
public final class XMLResourceBundle
extends ResourceBundle {
    private final ICommonsOrderedMap<String, String> m_aValues;

    @ReturnsMutableCopy
    public static @NonNull ICommonsOrderedMap<String, String> readFromPropertiesXML(@WillClose @NonNull InputStream inputStream) {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        IMicroDocument iMicroDocument = MicroReader.readMicroXML(inputStream);
        if (iMicroDocument != null) {
            for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("entry")) {
                commonsLinkedHashMap.put((Object)iMicroElement.getAttributeValue("key"), (Object)iMicroElement.getTextContent());
            }
        }
        return commonsLinkedHashMap;
    }

    public static @NonNull IMicroDocument getAsPropertiesXML(@NonNull Map<String, String> map) {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.addElement("properties");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ((IMicroElement)iMicroElement.addElement("entry").setAttribute("key", entry.getKey())).addText(entry.getValue());
        }
        return microDocument;
    }

    @DevelopersNote(value="Don't use it manually - use the static methods of this class!")
    XMLResourceBundle(@WillNotClose @NonNull InputStream inputStream) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        this.m_aValues = XMLResourceBundle.readFromPropertiesXML(inputStream);
    }

    @ReturnsMutableCopy
    public @NonNull ICommonsMap<String, String> getAllValues() {
        return this.m_aValues.getClone();
    }

    @Override
    @CodingStyleguideUnaware
    protected Set<String> handleKeySet() {
        return this.m_aValues.keySet();
    }

    @Override
    protected String handleGetObject(@Nullable String string) {
        return (String)this.m_aValues.get((Object)string);
    }

    @Override
    public Enumeration<String> getKeys() {
        return EnumerationHelper.getEnumeration((Iterable)this.m_aValues.keySet());
    }

    public static @NonNull XMLResourceBundle getXMLBundle(@NonNull String string) {
        return XMLResourceBundle.getXMLBundle(string, Locale.getDefault());
    }

    public static @NonNull XMLResourceBundle getXMLBundle(@NonNull String string, @NonNull Locale locale) {
        return (XMLResourceBundle)ResourceBundle.getBundle(string, locale, new XMLResourceBundleControl());
    }

    public static @NonNull XMLResourceBundle getXMLBundle(@NonNull String string, @NonNull Locale locale, @NonNull ClassLoader classLoader) {
        return (XMLResourceBundle)ResourceBundle.getBundle(string, locale, classLoader, new XMLResourceBundleControl());
    }
}

