/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.OverridingMethodsMustInvokeSuper;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.annotation.style.ReturnsMutableObject;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.state.EContinue;
import com.helger.base.string.StringHelper;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsIterable;
import com.helger.collection.commons.ICommonsList;
import com.helger.typeconvert.impl.TypeConverter;
import com.helger.xml.microdom.AbstractMicroNode;
import com.helger.xml.microdom.EMicroEvent;
import com.helger.xml.microdom.EMicroNodeType;
import com.helger.xml.microdom.IMicroCDATA;
import com.helger.xml.microdom.IMicroNode;
import com.helger.xml.microdom.IMicroNodeWithChildren;
import com.helger.xml.microdom.IMicroText;
import com.helger.xml.microdom.MicroException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AbstractMicroNodeWithChildren
extends AbstractMicroNode
implements IMicroNodeWithChildren {
    private ICommonsList<IMicroNode> m_aChildren;

    @ReturnsMutableObject(value="efficient access")
    protected final @Nullable ICommonsList<IMicroNode> directGetAllChildren() {
        return this.m_aChildren;
    }

    private void _afterInsertAsChildOfThis(@NonNull AbstractMicroNode abstractMicroNode) {
        abstractMicroNode.internalSetParentNode(this);
        this.onEvent(EMicroEvent.NODE_INSERTED, this, abstractMicroNode);
    }

    @Override
    protected void onAddChild(@NonNull AbstractMicroNode abstractMicroNode) {
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to documents");
        }
        if (this.m_aChildren == null) {
            this.m_aChildren = new CommonsArrayList();
        }
        this.m_aChildren.add((Object)abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    @Override
    protected final void onInsertBefore(@NonNull AbstractMicroNode abstractMicroNode, @NonNull IMicroNode iMicroNode) {
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (iMicroNode == null || this.m_aChildren == null) {
            throw new MicroException("Cannot add before element which is not contained!");
        }
        int n = this.m_aChildren.lastIndexOf((Object)iMicroNode);
        if (n == -1) {
            throw new MicroException("Cannot add before element which is not contained!");
        }
        this.m_aChildren.add(n, (Object)abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    @Override
    protected final void onInsertAfter(@NonNull AbstractMicroNode abstractMicroNode, @NonNull IMicroNode iMicroNode) {
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (iMicroNode == null || this.m_aChildren == null) {
            throw new MicroException("Cannot add after element which is not contained!");
        }
        int n = this.m_aChildren.lastIndexOf((Object)iMicroNode);
        if (n == -1) {
            throw new MicroException("Cannot add after element which is not contained!");
        }
        this.m_aChildren.add(n + 1, (Object)abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    @Override
    protected final void onInsertAtIndex(@Nonnegative int n, @NonNull AbstractMicroNode abstractMicroNode) {
        if (n < 0) {
            throw new MicroException("Cannot insert element at index " + n + "!");
        }
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (this.m_aChildren == null) {
            this.m_aChildren = new CommonsArrayList();
        }
        this.m_aChildren.add(Math.min(n, this.m_aChildren.size()), (Object)abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    private void _afterRemoveChildOfThis(@NonNull IMicroNode iMicroNode) {
        if (this.m_aChildren.contains((Object)iMicroNode)) {
            throw new IllegalStateException("Child " + String.valueOf(iMicroNode) + " is contained more than once in it's parents list");
        }
        if (this.m_aChildren.isEmpty()) {
            this.m_aChildren = null;
        }
        ((AbstractMicroNode)iMicroNode).internalResetParentNode();
        this.onEvent(EMicroEvent.NODE_REMOVED, this, iMicroNode);
    }

    @Override
    protected final @NonNull EChange onRemoveChild(@NonNull IMicroNode iMicroNode) {
        if (!iMicroNode.hasParent()) {
            throw new MicroException("The passed child node to be removed has no parent!");
        }
        if (this.m_aChildren == null || !this.m_aChildren.remove((Object)iMicroNode)) {
            return EChange.UNCHANGED;
        }
        this._afterRemoveChildOfThis(iMicroNode);
        return EChange.CHANGED;
    }

    @Override
    protected final @NonNull EChange onRemoveChildAtIndex(@Nonnegative int n) {
        IMicroNode iMicroNode = this.getChildAtIndex(n);
        if (iMicroNode == null) {
            return EChange.UNCHANGED;
        }
        if (!iMicroNode.hasParent()) {
            throw new MicroException("Internal inconsistency: the passed child node to be removed has no parent!");
        }
        if (this.m_aChildren.remove(n) != iMicroNode) {
            throw new MicroException("Internal inconsistency: remove resulted in an illegal object!");
        }
        this._afterRemoveChildOfThis(iMicroNode);
        return EChange.CHANGED;
    }

    @Override
    protected final @NonNull EChange onRemoveAllChildren() {
        if (this.m_aChildren == null || this.m_aChildren.isEmpty()) {
            return EChange.UNCHANGED;
        }
        while (this.hasChildren()) {
            this.removeChildAtIndex(0);
        }
        return EChange.CHANGED;
    }

    @Override
    public final boolean hasChildren() {
        return this.m_aChildren != null && this.m_aChildren.isNotEmpty();
    }

    @Override
    @ReturnsMutableCopy
    public final @Nullable ICommonsList<IMicroNode> getAllChildren() {
        return this.m_aChildren == null ? null : (ICommonsList)this.m_aChildren.getClone();
    }

    @Override
    public final @Nullable ICommonsIterable<IMicroNode> getChildren() {
        return this.m_aChildren;
    }

    @Override
    public final void forAllChildren(@NonNull Consumer<? super IMicroNode> consumer) {
        if (this.m_aChildren != null) {
            this.m_aChildren.forEach(consumer);
        }
    }

    @Override
    public @NonNull EContinue forAllChildrenBreakable(@NonNull Function<? super IMicroNode, EContinue> function) {
        if (this.m_aChildren != null) {
            return this.m_aChildren.forEachBreakable(function);
        }
        return EContinue.CONTINUE;
    }

    @Override
    public final void forAllChildren(@NonNull Predicate<? super IMicroNode> predicate, @NonNull Consumer<? super IMicroNode> consumer) {
        if (this.m_aChildren != null) {
            this.m_aChildren.findAll(predicate, consumer);
        }
    }

    @Override
    public final <DSTTYPE> void forAllChildrenMapped(@NonNull Predicate<? super IMicroNode> predicate, @NonNull Function<? super IMicroNode, ? extends DSTTYPE> function, @NonNull Consumer<? super DSTTYPE> consumer) {
        if (this.m_aChildren != null) {
            this.m_aChildren.findAllMapped(predicate, function, consumer);
        }
    }

    @Override
    public boolean containsAnyChild(@NonNull Predicate<? super IMicroNode> predicate) {
        ValueEnforcer.notNull(predicate, (String)"Filter");
        if (this.m_aChildren == null) {
            return false;
        }
        return this.m_aChildren.containsAny(predicate);
    }

    @Override
    public final @Nullable IMicroNode getChildAtIndex(@Nonnegative int n) {
        return this.m_aChildren == null ? null : (IMicroNode)this.m_aChildren.getAtIndex(n);
    }

    @Override
    public final int getChildCount() {
        return this.m_aChildren == null ? 0 : this.m_aChildren.size();
    }

    @Override
    public final @Nullable IMicroNode getFirstChild() {
        return this.m_aChildren == null ? null : (IMicroNode)this.m_aChildren.getFirstOrNull();
    }

    @Override
    public final @Nullable IMicroNode findFirstChild(@NonNull Predicate<? super IMicroNode> predicate) {
        return this.m_aChildren == null ? null : (IMicroNode)this.m_aChildren.findFirst(predicate);
    }

    @Override
    public final <DSTTYPE> @Nullable DSTTYPE findFirstChildMapped(@NonNull Predicate<? super IMicroNode> predicate, @NonNull Function<? super IMicroNode, ? extends DSTTYPE> function) {
        return (DSTTYPE)(this.m_aChildren == null ? null : this.m_aChildren.findFirstMapped(predicate, function));
    }

    @Override
    public final @Nullable IMicroNode getLastChild() {
        return this.m_aChildren == null ? null : (IMicroNode)this.m_aChildren.getLastOrNull();
    }

    @Override
    public @Nullable String getTextContent() {
        if (this.hasNoChildren()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IMicroNode iMicroNode : this.m_aChildren) {
            IMicroNodeWithChildren iMicroNodeWithChildren;
            Object object;
            EMicroNodeType eMicroNodeType = iMicroNode.getType();
            if (eMicroNodeType.isText()) {
                object = (IMicroText)iMicroNode;
                if (((IMicroText)iMicroNode).isElementContentWhitespace()) continue;
                stringBuilder.append(object.getData());
                continue;
            }
            if (eMicroNodeType.isCDATA()) {
                object = (IMicroCDATA)iMicroNode;
                stringBuilder.append(object.getNodeValue());
                continue;
            }
            if (!(iMicroNode instanceof IMicroNodeWithChildren) || !StringHelper.isNotEmpty((String)(object = (iMicroNodeWithChildren = (IMicroNodeWithChildren)iMicroNode).getTextContent()))) continue;
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    @Override
    public <DSTTYPE> @Nullable DSTTYPE getTextContentWithConversion(@NonNull Class<DSTTYPE> clazz) {
        String string = this.getTextContent();
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        return (DSTTYPE)TypeConverter.convert((Object)string, clazz);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        int n;
        if (iMicroNode == this) {
            return true;
        }
        if (iMicroNode == null || !this.getClass().equals(iMicroNode.getClass())) {
            return false;
        }
        AbstractMicroNodeWithChildren abstractMicroNodeWithChildren = (AbstractMicroNodeWithChildren)iMicroNode;
        if (this.m_aChildren == null && abstractMicroNodeWithChildren.m_aChildren == null) {
            return true;
        }
        if (this.m_aChildren == null || abstractMicroNodeWithChildren.m_aChildren == null) {
            return false;
        }
        int n2 = this.m_aChildren.size();
        if (n2 != (n = abstractMicroNodeWithChildren.m_aChildren.size())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            IMicroNode iMicroNode2;
            IMicroNode iMicroNode3 = (IMicroNode)this.m_aChildren.get(i);
            if (iMicroNode3.isEqualContent(iMicroNode2 = (IMicroNode)abstractMicroNodeWithChildren.m_aChildren.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("childrenCount", this.m_aChildren == null ? 0 : this.m_aChildren.size()).getToString();
    }
}

