/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.WillClose;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.stream.StreamHelper;
import com.helger.base.pool.ObjectPool;
import com.helger.base.timing.StopWatch;
import com.helger.io.resource.IReadableResource;
import com.helger.statistics.api.IMutableStatisticsHandlerCounter;
import com.helger.statistics.api.IMutableStatisticsHandlerTimer;
import com.helger.statistics.impl.StatisticsManager;
import com.helger.xml.XMLFactory;
import com.helger.xml.sax.CollectingSAXErrorHandler;
import com.helger.xml.sax.InputSourceFactory;
import com.helger.xml.serialize.read.DOMReaderSettings;
import com.helger.xml.serialize.read.IDOMReaderSettings;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

@ThreadSafe
public final class DOMReader {
    private static final IMutableStatisticsHandlerTimer STARS_DOM_TIMER = StatisticsManager.getTimerHandler((String)(DOMReader.class.getName() + "$DOM"));
    private static final IMutableStatisticsHandlerTimer STATS_DOM_SCHEMA_TIMER = StatisticsManager.getTimerHandler((String)(DOMReader.class.getName() + "$DOMwithSchema"));
    private static final IMutableStatisticsHandlerCounter STATS_DOM_ERROR_COUNTER = StatisticsManager.getCounterHandler((String)(DOMReader.class.getName() + "$DOMERRORS"));
    private static final ObjectPool<DocumentBuilder> POOL = new ObjectPool(20, XMLFactory::createDocumentBuilder);
    private static final DOMReader INSTANCE = new DOMReader();

    private DOMReader() {
    }

    public static void reinitialize() {
        POOL.clearUnusedItems();
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource inputSource) {
        return DOMReader.readXMLDOM(inputSource, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose InputStream inputStream) {
        return DOMReader.readXMLDOM(inputStream, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull @WillClose InputStream inputStream, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        ValueEnforcer.notNull((Object)inputStream, (String)"InputStream");
        try {
            Document document = DOMReader.readXMLDOM(InputSourceFactory.create(inputStream), iDOMReaderSettings);
            return document;
        }
        finally {
            StreamHelper.close((AutoCloseable)inputStream);
        }
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader reader) {
        return DOMReader.readXMLDOM(reader, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull Reader reader, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        ValueEnforcer.notNull((Object)reader, (String)"Reader");
        try {
            Document document = DOMReader.readXMLDOM(InputSourceFactory.create(reader), iDOMReaderSettings);
            return document;
        }
        finally {
            StreamHelper.close((AutoCloseable)reader);
        }
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URI uRI) {
        return DOMReader.readXMLDOM(uRI, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URI uRI, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        return DOMReader.readXMLDOM(InputSourceFactory.create(uRI), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URL uRL) {
        return DOMReader.readXMLDOM(uRL, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull URL uRL, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        return DOMReader.readXMLDOM(InputSourceFactory.create(uRL), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File file) {
        return DOMReader.readXMLDOM(file, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull File file, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        return DOMReader.readXMLDOM(InputSourceFactory.create(file), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull Path path) {
        return DOMReader.readXMLDOM(path, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull Path path, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        InputSource inputSource = InputSourceFactory.create(path);
        return inputSource == null ? null : DOMReader.readXMLDOM(inputSource, iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource iReadableResource) {
        return DOMReader.readXMLDOM(iReadableResource, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull IReadableResource iReadableResource, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        return DOMReader.readXMLDOM(InputSourceFactory.create(iReadableResource), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String string) {
        return DOMReader.readXMLDOM(string, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull String string, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        return DOMReader.readXMLDOM(InputSourceFactory.create(string), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull CharSequence charSequence) {
        return DOMReader.readXMLDOM(charSequence, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull CharSequence charSequence, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        return DOMReader.readXMLDOM(InputSourceFactory.create(charSequence), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull ByteBuffer byteBuffer) {
        return DOMReader.readXMLDOM(byteBuffer, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull ByteBuffer byteBuffer, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        return DOMReader.readXMLDOM(InputSourceFactory.create(byteBuffer), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray) {
        return DOMReader.readXMLDOM(byArray, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        return DOMReader.readXMLDOM(InputSourceFactory.create(byArray), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        return DOMReader.readXMLDOM(byArray, n, n2, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        return DOMReader.readXMLDOM(InputSourceFactory.create(byArray, n, n2), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray) {
        return DOMReader.readXMLDOM(cArray, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        return DOMReader.readXMLDOM(InputSourceFactory.create(cArray), iDOMReaderSettings);
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        return DOMReader.readXMLDOM(cArray, n, n2, (IDOMReaderSettings)new DOMReaderSettings());
    }

    @Nullable
    public static Document readXMLDOM(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        return DOMReader.readXMLDOM(InputSourceFactory.create(cArray, n, n2), iDOMReaderSettings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document readXMLDOM(@WillClose @Nonnull InputSource inputSource, @Nonnull IDOMReaderSettings iDOMReaderSettings) {
        ValueEnforcer.notNull((Object)inputSource, (String)"InputSource");
        ValueEnforcer.notNull((Object)iDOMReaderSettings, (String)"Settings");
        Document document = null;
        try {
            DocumentBuilder documentBuilder;
            Object object;
            StopWatch stopWatch = StopWatch.createdStarted();
            boolean bl = false;
            if (iDOMReaderSettings.requiresNewXMLParser()) {
                object = XMLFactory.createDefaultDocumentBuilderFactory();
                iDOMReaderSettings.applyToDocumentBuilderFactory((DocumentBuilderFactory)object);
                documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            } else {
                documentBuilder = (DocumentBuilder)POOL.borrowObject();
                bl = true;
            }
            try {
                CollectingSAXErrorHandler collectingSAXErrorHandler;
                iDOMReaderSettings.applyToDocumentBuilder(documentBuilder);
                ErrorHandler errorHandler = iDOMReaderSettings.getErrorHandler();
                if (errorHandler instanceof CollectingSAXErrorHandler) {
                    collectingSAXErrorHandler = (CollectingSAXErrorHandler)errorHandler;
                    object = collectingSAXErrorHandler;
                } else {
                    object = new CollectingSAXErrorHandler();
                    documentBuilder.setErrorHandler(object.andThen(errorHandler));
                }
                document = documentBuilder.parse(inputSource);
                if (iDOMReaderSettings.getSchema() == null) {
                    STARS_DOM_TIMER.addTime(stopWatch.stopAndGetMillis());
                } else {
                    STATS_DOM_SCHEMA_TIMER.addTime(stopWatch.stopAndGetMillis());
                }
                if (((CollectingSAXErrorHandler)object).containsAtLeastOneError()) {
                    collectingSAXErrorHandler = null;
                    return collectingSAXErrorHandler;
                }
            }
            finally {
                if (bl) {
                    POOL.returnObject((Object)documentBuilder);
                }
            }
        }
        catch (Exception exception) {
            iDOMReaderSettings.exceptionCallbacks().forEach(iExceptionCallback -> iExceptionCallback.onException((Throwable)exception));
            STATS_DOM_ERROR_COUNTER.increment();
        }
        finally {
            StreamHelper.close((AutoCloseable)inputSource.getByteStream());
            StreamHelper.close((AutoCloseable)inputSource.getCharacterStream());
        }
        return document;
    }
}

