/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.annotation.Nonnegative;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.io.nonblocking.NonBlockingStringReader;
import com.helger.base.tostring.ToStringGenerator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.Reader;
import org.xml.sax.InputSource;

public class StringSAXInputSource
extends InputSource {
    private final String m_sText;

    public StringSAXInputSource(@Nonnull char[] cArray) {
        this(new String(cArray));
    }

    public StringSAXInputSource(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this(new String(cArray, n, n2));
    }

    public StringSAXInputSource(@Nonnull CharSequence charSequence) {
        this(charSequence instanceof String ? (string = (String)charSequence) : charSequence.toString());
        String string;
    }

    public StringSAXInputSource(@Nonnull String string) {
        this(string, null);
    }

    public StringSAXInputSource(@Nonnull String string, @Nullable String string2) {
        this.m_sText = (String)ValueEnforcer.notNull((Object)string, (String)"Text");
        this.setSystemId(string2);
    }

    @Nonnull
    public final String getText() {
        return this.m_sText;
    }

    @Override
    public Reader getCharacterStream() {
        return new NonBlockingStringReader(this.m_sText);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("text", (Object)this.m_sText).append("systemID", (Object)this.getSystemId()).getToString();
    }
}

