/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.namespace;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsMap;
import com.helger.collection.helper.CollectionHelperExt;
import com.helger.xml.namespace.AbstractNamespaceContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Iterator;

@Immutable
public class SingleElementNamespaceContext
extends AbstractNamespaceContext {
    private final String m_sPrefix;
    private final String m_sNamespaceURI;

    public SingleElementNamespaceContext(@Nonnull @Nonempty String string) {
        this("", string);
    }

    public SingleElementNamespaceContext(@Nonnull String string, @Nonnull @Nonempty String string2) {
        this.m_sPrefix = (String)ValueEnforcer.notNull((Object)string, (String)"Prefix");
        this.m_sNamespaceURI = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"NamespaceURI");
    }

    @Override
    @Nullable
    public String getDefaultNamespaceURI() {
        return this.m_sPrefix.equals("") ? this.m_sNamespaceURI : null;
    }

    @Override
    @Nullable
    protected Iterator<String> getCustomPrefixes(@Nullable String string) {
        return this.m_sNamespaceURI.equals(string) ? new CommonsArrayList((Object)this.m_sPrefix).iterator() : null;
    }

    @Override
    @Nullable
    protected String getCustomPrefix(@Nullable String string) {
        return this.m_sNamespaceURI.equals(string) ? this.m_sPrefix : null;
    }

    @Override
    @Nullable
    protected String getCustomNamespaceURI(@Nullable String string) {
        return this.m_sPrefix.equals(string) ? this.m_sNamespaceURI : null;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<String, String> getPrefixToNamespaceURIMap() {
        return CollectionHelperExt.createMap((Object)this.m_sPrefix, (Object)this.m_sNamespaceURI);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("prefix", (Object)this.m_sPrefix).append("namespaceURI", (Object)this.m_sNamespaceURI).getToString();
    }
}

