/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.util;

import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsIterableIterator;
import com.helger.collection.commons.ICommonsList;
import com.helger.xml.microdom.IMicroNode;
import jakarta.annotation.Nonnull;
import java.util.NoSuchElementException;

public class MicroRecursiveIterator
implements ICommonsIterableIterator<IMicroNode> {
    private final ICommonsList<IMicroNode> m_aOpen = new CommonsArrayList();

    public MicroRecursiveIterator(@Nonnull IMicroNode iMicroNode) {
        ValueEnforcer.notNull((Object)iMicroNode, (String)"Node");
        this.m_aOpen.add((Object)iMicroNode);
    }

    public boolean hasNext() {
        return this.m_aOpen.isNotEmpty();
    }

    @Nonnull
    public IMicroNode next() {
        if (this.m_aOpen.isEmpty()) {
            throw new NoSuchElementException();
        }
        IMicroNode iMicroNode = (IMicroNode)this.m_aOpen.remove(0);
        if (iMicroNode.hasChildren()) {
            this.m_aOpen.addAll(0, iMicroNode.getAllChildren());
        }
        return iMicroNode;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Open", this.m_aOpen).getToString();
    }

    @Nonnull
    public static MicroRecursiveIterator createChildNodeIterator(@Nonnull IMicroNode iMicroNode) {
        MicroRecursiveIterator microRecursiveIterator = new MicroRecursiveIterator(iMicroNode);
        microRecursiveIterator.next();
        return microRecursiveIterator;
    }
}

