/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.schema;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.ThreadSafe;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.state.EChange;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.cache.impl.Cache;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.io.resource.IReadableResource;
import com.helger.xml.transform.TransformSourceFactory;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

@ThreadSafe
public class SchemaCache
extends Cache<ICommonsList<? extends IReadableResource>, Schema> {
    private final String m_sSchemaTypeName;
    private final SchemaFactory m_aSchemaFactory;

    public SchemaCache(@Nonnull String string, @Nonnull SchemaFactory schemaFactory, @Nullable ErrorHandler errorHandler, @Nullable LSResourceResolver lSResourceResolver) {
        super(iCommonsList -> SchemaCache.createSchema(schemaFactory, string, (ICommonsList<? extends IReadableResource>)iCommonsList), 500, SchemaCache.class.getName() + "$" + string);
        ValueEnforcer.notNull((Object)string, (String)"SchemaTypeName");
        ValueEnforcer.notNull((Object)schemaFactory, (String)"SchemaFactory");
        this.m_sSchemaTypeName = string;
        this.m_aSchemaFactory = schemaFactory;
        this.m_aSchemaFactory.setErrorHandler(errorHandler);
        this.m_aSchemaFactory.setResourceResolver(lSResourceResolver);
    }

    @Nonnull
    public final String getSchemaTypeName() {
        return this.m_sSchemaTypeName;
    }

    @Nonnull
    public final SchemaFactory getSchemaFactory() {
        return this.m_aSchemaFactory;
    }

    @Nullable
    public ErrorHandler getErrorHandler() {
        return this.m_aSchemaFactory.getErrorHandler();
    }

    @Nullable
    public LSResourceResolver getResourceResolver() {
        return this.m_aSchemaFactory.getResourceResolver();
    }

    @Nonnull
    public static Schema createSchema(@Nonnull SchemaFactory schemaFactory, @Nonnull String string, @Nonnull @Nonempty ICommonsList<? extends IReadableResource> iCommonsList) {
        ValueEnforcer.notNull((Object)schemaFactory, (String)"SchemaFactory");
        ValueEnforcer.notEmptyNoNullValue(iCommonsList, (String)"Resources");
        Source[] sourceArray = new Source[iCommonsList.size()];
        for (int i = 0; i < iCommonsList.size(); ++i) {
            sourceArray[i] = TransformSourceFactory.create((IReadableResource)iCommonsList.get(i));
        }
        try {
            Schema schema = schemaFactory.newSchema(sourceArray);
            if (schema == null) {
                throw new IllegalStateException("Failed to create " + string + " schema from " + iCommonsList.toString());
            }
            return schema;
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException("Failed to parse " + string + " from " + iCommonsList.toString(), sAXException);
        }
    }

    @Nonnull
    public final Schema getSchema(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        return (Schema)this.getFromCache(new CommonsArrayList((Object)iReadableResource));
    }

    @Nonnull
    public final Schema getSchema(IReadableResource ... iReadableResourceArray) {
        ValueEnforcer.notEmptyNoNullValue((Object[])iReadableResourceArray, (String)"Resources");
        return (Schema)this.getFromCache(new CommonsArrayList((Object[])iReadableResourceArray));
    }

    @Nonnull
    public final Schema getSchema(@Nonnull @Nonempty Collection<? extends IReadableResource> collection) {
        ValueEnforcer.notEmptyNoNullValue(collection, (String)"Resources");
        return (Schema)this.getFromCache(new CommonsArrayList(collection));
    }

    @Nonnull
    public final Validator getValidatorFromSchema(@Nonnull Schema schema) {
        ValueEnforcer.notNull((Object)schema, (String)"Schema");
        Validator validator = schema.newValidator();
        validator.setErrorHandler(this.m_aSchemaFactory.getErrorHandler());
        return validator;
    }

    @Nonnull
    public final Validator getValidator(@Nonnull IReadableResource iReadableResource) {
        return this.getValidatorFromSchema(this.getSchema(iReadableResource));
    }

    @Nonnull
    public final Validator getValidator(IReadableResource ... iReadableResourceArray) {
        return this.getValidatorFromSchema(this.getSchema(iReadableResourceArray));
    }

    @Nonnull
    public final Validator getValidator(@Nonnull @Nonempty Collection<? extends IReadableResource> collection) {
        return this.getValidatorFromSchema(this.getSchema(collection));
    }

    @Nonnull
    public EChange removeFromCache(@Nonnull IReadableResource iReadableResource) {
        return this.removeFromCache(new CommonsArrayList((Object)iReadableResource));
    }

    public String toString() {
        return ToStringGenerator.getDerived((String)super.toString()).append("schemaTypeName", (Object)this.m_sSchemaTypeName).getToString();
    }
}

