/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.convert;

import com.helger.annotation.Nonempty;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.typeconvert.impl.TypeConverter;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.convert.IMicroTypeConverter;
import com.helger.xml.microdom.convert.StringMicroTypeConverter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public final class StringBasedMicroTypeConverter<T>
implements IMicroTypeConverter<T> {
    private final Class<T> m_aNativeClass;

    public StringBasedMicroTypeConverter(@Nonnull Class<T> clazz) {
        ValueEnforcer.notNull(clazz, (String)"NativeClass");
        this.m_aNativeClass = clazz;
    }

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull T t, @Nullable String string, @Nonnull @Nonempty String string2) {
        String string3 = (String)TypeConverter.convert(t, String.class);
        return StringMicroTypeConverter.getInstance().convertToMicroElement(string3, string, string2);
    }

    @Override
    @Nonnull
    public T convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = StringMicroTypeConverter.getInstance().convertToNative(iMicroElement);
        return (T)TypeConverter.convert((Object)string, this.m_aNativeClass);
    }
}

