/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.transform;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.exception.InitializationException;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.StringHelper;
import com.helger.xml.XMLFactory;
import com.helger.xml.transform.DefaultTransformURIResolver;
import com.helger.xml.transform.LoggingTransformErrorListener;
import com.helger.xml.transform.TransformSourceFactory;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class XMLTransformerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLTransformerFactory.class);
    private static final TransformerFactory DEFAULT_FACTORY = XMLTransformerFactory.createTransformerFactory(new LoggingTransformErrorListener(Locale.ROOT), new DefaultTransformURIResolver());
    private static final XMLTransformerFactory INSTANCE;

    private XMLTransformerFactory() {
    }

    @Nonnull
    public static TransformerFactory createTransformerFactory(@Nullable ErrorListener errorListener, @Nullable URIResolver uRIResolver) {
        try {
            TransformerFactory transformerFactory = XMLFactory.createDefaultTransformerFactory();
            if (errorListener != null) {
                transformerFactory.setErrorListener(errorListener);
            }
            if (uRIResolver != null) {
                transformerFactory.setURIResolver(uRIResolver);
            }
            return transformerFactory;
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            throw new InitializationException("Failed to create XML TransformerFactory", (Throwable)transformerFactoryConfigurationError);
        }
    }

    public static void makeTransformerFactorySecure(@Nonnull TransformerFactory transformerFactory, String ... stringArray) {
        ValueEnforcer.notNull((Object)transformerFactory, (String)"Factory");
        try {
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            String string = StringHelper.getImplodedNonEmpty((char)',', (String[])stringArray);
            if (string.length() > 0) {
                transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", string);
                transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", string);
            }
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new InitializationException("Failed to secure XML TransformerFactory", (Throwable)transformerConfigurationException);
        }
    }

    @Nonnull
    public static TransformerFactory getDefaultTransformerFactory() {
        return DEFAULT_FACTORY;
    }

    @Nullable
    public static Transformer newTransformer() {
        return XMLTransformerFactory.newTransformer(DEFAULT_FACTORY);
    }

    @Nullable
    public static Transformer newTransformer(@Nonnull TransformerFactory transformerFactory) {
        ValueEnforcer.notNull((Object)transformerFactory, (String)"TransformerFactory");
        try {
            return transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            LOGGER.error("Failed to create transformer", (Throwable)transformerConfigurationException);
            return null;
        }
    }

    @Nullable
    public static Transformer newTransformer(@Nonnull IReadableResource iReadableResource) {
        return XMLTransformerFactory.newTransformer(DEFAULT_FACTORY, iReadableResource);
    }

    @Nullable
    public static Transformer newTransformer(@Nonnull TransformerFactory transformerFactory, @Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        return XMLTransformerFactory.newTransformer(transformerFactory, TransformSourceFactory.create(iReadableResource));
    }

    @Nullable
    public static Transformer newTransformer(@Nonnull Source source) {
        return XMLTransformerFactory.newTransformer(DEFAULT_FACTORY, source);
    }

    @Nullable
    public static Transformer newTransformer(@Nonnull TransformerFactory transformerFactory, @Nonnull Source source) {
        ValueEnforcer.notNull((Object)transformerFactory, (String)"TransformerFactory");
        ValueEnforcer.notNull((Object)source, (String)"Source");
        try {
            return transformerFactory.newTransformer(source);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            LOGGER.error("Failed to parse " + String.valueOf(source), (Throwable)transformerConfigurationException);
            return null;
        }
    }

    @Nullable
    public static Templates newTemplates(@Nonnull IReadableResource iReadableResource) {
        return XMLTransformerFactory.newTemplates(DEFAULT_FACTORY, iReadableResource);
    }

    @Nullable
    public static Templates newTemplates(@Nonnull Source source) {
        return XMLTransformerFactory.newTemplates(DEFAULT_FACTORY, source);
    }

    @Nullable
    public static Templates newTemplates(@Nonnull TransformerFactory transformerFactory, @Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull((Object)iReadableResource, (String)"Resource");
        return XMLTransformerFactory.newTemplates(transformerFactory, TransformSourceFactory.create(iReadableResource));
    }

    @Nullable
    public static Templates newTemplates(@Nonnull TransformerFactory transformerFactory, @Nonnull Source source) {
        ValueEnforcer.notNull((Object)transformerFactory, (String)"TransformerFactory");
        ValueEnforcer.notNull((Object)source, (String)"Source");
        try {
            return transformerFactory.newTemplates(source);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            LOGGER.error("Failed to parse " + String.valueOf(source), (Throwable)transformerConfigurationException);
            return null;
        }
    }

    static {
        XMLTransformerFactory.makeTransformerFactorySecure(DEFAULT_FACTORY, new String[0]);
        INSTANCE = new XMLTransformerFactory();
    }
}

