/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.sax;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.string.ToStringGenerator;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class ReadableResourceSAXInputSource
extends InputSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadableResourceSAXInputSource.class);
    private final IHasInputStream m_aISP;

    public ReadableResourceSAXInputSource(@Nonnull IReadableResource iReadableResource) {
        this((IHasInputStream)iReadableResource, iReadableResource.getResourceID());
    }

    public ReadableResourceSAXInputSource(@Nonnull IHasInputStream iHasInputStream, @Nullable String string) {
        this.m_aISP = (IHasInputStream)ValueEnforcer.notNull((Object)iHasInputStream, (String)"InputStreamProvider");
        this.setSystemId(string);
    }

    @Nonnull
    public final IHasInputStream getInputStreamProvider() {
        return this.m_aISP;
    }

    @Override
    public InputStream getByteStream() {
        InputStream inputStream = this.m_aISP.getInputStream();
        if (inputStream == null) {
            LOGGER.warn("Failed to open input stream for " + String.valueOf(this.m_aISP));
        }
        return inputStream;
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("resource", (Object)this.m_aISP).append("systemID", (Object)this.getSystemId()).getToString();
    }
}

