/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.microdom.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.hierarchy.IChildrenProvider;
import com.helger.commons.string.StringHelper;
import com.helger.xml.microdom.IMicroElement;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ChildrenProviderElementWithName
implements IChildrenProvider<IMicroElement> {
    private final String m_sNamespaceURI;
    private final String m_sTagName;

    public ChildrenProviderElementWithName(@Nonnull @Nonempty String string) {
        this(null, string);
    }

    public ChildrenProviderElementWithName(@Nullable String string, @Nonnull @Nonempty String string2) {
        this.m_sNamespaceURI = string;
        this.m_sTagName = (String)ValueEnforcer.notEmpty((CharSequence)string2, (String)"TagName");
    }

    public boolean hasChildren(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null || !iMicroElement.isElement()) {
            return false;
        }
        if (StringHelper.hasText((String)this.m_sNamespaceURI)) {
            return iMicroElement.hasChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return iMicroElement.hasChildElements(this.m_sTagName);
    }

    @Nonnegative
    public int getChildCount(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            return 0;
        }
        return this.getAllChildren(iMicroElement).size();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends IMicroElement> getAllChildren(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            return new CommonsArrayList();
        }
        if (StringHelper.hasText((String)this.m_sNamespaceURI)) {
            return iMicroElement.getAllChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return iMicroElement.getAllChildElements(this.m_sTagName);
    }
}

