/*
 * Decompiled with CFR 0.152.
 */
package com.helger.xml.serialize.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetHelper;
import com.helger.commons.charset.EUnicodeBOM;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.io.stream.NonBlockingByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class XMLCharsetDeterminator {
    public static final Charset FALLBACK_CHARSET = StandardCharsets.UTF_8;
    private static final ICommonsSet<Charset> XML_CHARSETS = new CommonsHashSet();
    private static final Charset CHARSET_UTF_32BE;
    private static final Charset CHARSET_UTF_32LE;
    private static final Charset CHARSET_EBCDIC;
    private static final Charset CHARSET_IBM290;
    private static final byte[] CS_UTF32_BE;
    private static final byte[] CS_UTF32_LE;
    private static final byte[] CS_UTF16_BE;
    private static final byte[] CS_UTF16_LE;
    private static final byte[] CS_UTF8;
    private static final byte[] CS_EBCDIC;
    private static final byte[] CS_IBM290;

    private XMLCharsetDeterminator() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<Charset> getAllSupportedCharsets() {
        return (ICommonsSet)XML_CHARSETS.getClone();
    }

    /*
     * Exception decompiling
     */
    @Nullable
    private static Charset _parseXMLEncoding(@Nonnull byte[] var0, @Nonnegative int var1_1, @Nonnull Charset var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean _match(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnull byte[] byArray2) {
        int n2 = byArray2.length;
        for (int i = 0; i < n2; ++i) {
            if (byArray[n + i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static Charset determineXMLCharset(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull((Object)byArray, (String)"Bytes");
        Charset charset = null;
        int n = 0;
        if (byArray.length > 0) {
            try (NonBlockingByteArrayInputStream nonBlockingByteArrayInputStream = new NonBlockingByteArrayInputStream(byArray, 0, Math.min(EUnicodeBOM.getMaximumByteCount(), byArray.length));){
                CharsetHelper.InputStreamAndCharset inputStreamAndCharset = CharsetHelper.getInputStreamAndCharsetFromBOM((InputStream)nonBlockingByteArrayInputStream);
                if (inputStreamAndCharset.hasBOM()) {
                    n = inputStreamAndCharset.getBOM().getByteCount();
                }
                if (inputStreamAndCharset.hasCharset()) {
                    charset = inputStreamAndCharset.getCharset();
                }
            }
        }
        if (charset == null && byArray.length - n >= 4) {
            if (XMLCharsetDeterminator._match(byArray, n, CS_UTF32_BE)) {
                charset = CHARSET_UTF_32BE;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_UTF32_LE)) {
                charset = CHARSET_UTF_32LE;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_UTF16_BE)) {
                charset = StandardCharsets.UTF_16BE;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_UTF16_LE)) {
                charset = StandardCharsets.UTF_16LE;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_UTF8)) {
                charset = StandardCharsets.UTF_8;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_EBCDIC)) {
                charset = CHARSET_EBCDIC;
            } else if (XMLCharsetDeterminator._match(byArray, n, CS_IBM290)) {
                charset = CHARSET_IBM290;
            }
        }
        if (charset == null) {
            charset = FALLBACK_CHARSET;
        }
        return XMLCharsetDeterminator._parseXMLEncoding(byArray, n, charset);
    }

    static {
        for (Charset charset : CharsetHelper.getAllCharsets().values()) {
            if (!charset.canEncode() || charset.name().equals("JIS_X0212-1990") || charset.name().equals("x-IBM300") || charset.name().equals("x-IBM834") || charset.name().equals("x-JIS0208") || charset.name().equals("x-MacDingbat") || charset.name().equals("x-MacSymbol")) continue;
            XML_CHARSETS.add((Object)charset);
        }
        CHARSET_UTF_32BE = Charset.forName("UTF-32BE");
        CHARSET_UTF_32LE = Charset.forName("UTF-32LE");
        CHARSET_EBCDIC = Charset.forName("Cp1047");
        CHARSET_IBM290 = Charset.forName("IBM290");
        CS_UTF32_BE = new byte[]{0, 0, 0, 60};
        CS_UTF32_LE = new byte[]{60, 0, 0, 0};
        CS_UTF16_BE = new byte[]{0, 60, 0, 63};
        CS_UTF16_LE = new byte[]{60, 0, 63, 0};
        CS_UTF8 = new byte[]{60, 63, 120, 109};
        CS_EBCDIC = new byte[]{76, 111, -89, -108};
        CS_IBM290 = new byte[]{76, 111, -73, 117};
    }
}

