/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.authentication.credentials;

import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.spi.ServiceLoaderHelper;
import com.helger.collection.commons.CommonsArrayList;
import com.helger.collection.commons.ICommonsList;
import com.helger.security.authentication.credentials.IAuthCredentialToSubjectResolverSPI;
import com.helger.security.authentication.credentials.IAuthCredentials;
import com.helger.security.authentication.subject.IAuthSubject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;

@Immutable
public final class AuthCredentialToSubjectResolverManager {
    private static final List<IAuthCredentialToSubjectResolverSPI> HDL_LIST = ServiceLoaderHelper.getAllSPIImplementations(IAuthCredentialToSubjectResolverSPI.class);

    private AuthCredentialToSubjectResolverManager() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<IAuthCredentialToSubjectResolverSPI> getAllAuthCredentialToSubjectResolvers() {
        return new CommonsArrayList(HDL_LIST);
    }

    @Nonnegative
    public static int getAuthCredentialToSubjectResolverCount() {
        return HDL_LIST.size();
    }

    @Nullable
    public static IAuthSubject getSubjectFromCredentials(@Nonnull IAuthCredentials iAuthCredentials) {
        for (IAuthCredentialToSubjectResolverSPI iAuthCredentialToSubjectResolverSPI : HDL_LIST) {
            IAuthSubject iAuthSubject;
            if (!iAuthCredentialToSubjectResolverSPI.supportsCredentials(iAuthCredentials) || (iAuthSubject = iAuthCredentialToSubjectResolverSPI.getSubjectFromCredentials(iAuthCredentials)) == null) continue;
            return iAuthSubject;
        }
        return null;
    }
}

