/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.password.salt;

import com.helger.annotation.Nonempty;
import com.helger.annotation.Nonnegative;
import com.helger.annotation.concurrent.Immutable;
import com.helger.annotation.style.ReturnsMutableCopy;
import com.helger.base.array.ArrayHelper;
import com.helger.base.enforce.ValueEnforcer;
import com.helger.base.hashcode.HashCodeGenerator;
import com.helger.base.string.StringHelper;
import com.helger.base.string.StringHex;
import com.helger.base.tostring.ToStringGenerator;
import com.helger.security.password.salt.IPasswordSalt;
import com.helger.security.random.VerySecureRandom;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;

@Nonnegative
@Immutable
public final class PasswordSalt
implements IPasswordSalt {
    public static final int DEFAULT_SALT_BYTES = 32;
    private final byte[] m_aSaltBytes;
    private final String m_sSaltString;

    public PasswordSalt(@Nonnull @Nonempty byte[] byArray) {
        ValueEnforcer.notEmpty((byte[])byArray, (String)"Bytes");
        this.m_aSaltBytes = byArray;
        this.m_sSaltString = StringHex.getHexEncoded((byte[])byArray);
    }

    @Override
    @Nonnegative
    public int getSaltByteCount() {
        return this.m_aSaltBytes.length;
    }

    @Override
    @Nonnull
    @Nonempty
    @ReturnsMutableCopy
    public byte[] getSaltBytes() {
        return ArrayHelper.getCopy((byte[])this.m_aSaltBytes);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getSaltString() {
        return this.m_sSaltString;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordSalt passwordSalt = (PasswordSalt)object;
        return Arrays.equals(this.m_aSaltBytes, passwordSalt.m_aSaltBytes);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_aSaltBytes).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("Bytes#", this.m_aSaltBytes.length).getToString();
    }

    @Nonnull
    public static PasswordSalt createRandom() {
        return PasswordSalt.createRandom(32);
    }

    @Nonnull
    public static PasswordSalt createRandom(@Nonnegative int n) {
        ValueEnforcer.isGT0((int)n, (String)"SaltBytes");
        byte[] byArray = new byte[n];
        VerySecureRandom.getInstance().nextBytes(byArray);
        return new PasswordSalt(byArray);
    }

    @Nullable
    public static PasswordSalt createFromStringMaybe(@Nullable String string) {
        if (StringHelper.isEmpty((String)string)) {
            return null;
        }
        byte[] byArray = StringHex.getHexDecoded((String)string);
        return new PasswordSalt(byArray);
    }
}

