/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.state.ISuccessIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.util.TextHelper;
import com.helger.security.keystore.EKeyStoreLoadError;
import java.security.KeyStore;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LoadedKey<T extends KeyStore.Entry>
implements ISuccessIndicator {
    private final T m_aKeyEntry;
    private final EKeyStoreLoadError m_eError;
    private final String[] m_aErrorParams;

    public LoadedKey(@Nullable T t, @Nullable EKeyStoreLoadError eKeyStoreLoadError, String ... stringArray) {
        this.m_aKeyEntry = t;
        this.m_eError = eKeyStoreLoadError;
        this.m_aErrorParams = stringArray;
    }

    public boolean isSuccess() {
        return this.m_aKeyEntry != null;
    }

    @Nullable
    public T getKeyEntry() {
        return this.m_aKeyEntry;
    }

    @Nullable
    public EKeyStoreLoadError getError() {
        return this.m_eError;
    }

    @Nullable
    public String[] getErrorParams() {
        return this.m_eError == null ? null : (String[])ArrayHelper.getCopy((Object[])this.m_aErrorParams);
    }

    @Nullable
    public String getErrorText(@Nonnull Locale locale) {
        return this.m_eError == null ? null : this.m_eError.getDisplayTextWithArgs(locale, this.m_aErrorParams);
    }

    @Nullable
    public static String getLoadError(@Nonnull LoadedKey<?> loadedKey) {
        return loadedKey == null ? null : loadedKey.getErrorText(TextHelper.EN);
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("KeyEntry", this.m_aKeyEntry).append("Error", (Enum)this.m_eError).append("ErrorParams", (Object[])this.m_aErrorParams).getToString();
    }
}

