/*
 * Decompiled with CFR 0.152.
 */
package com.helger.security.keystore;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.EnumHelper;
import com.helger.security.keystore.IKeyStoreType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum EKeyStoreType implements IKeyStoreType
{
    JKS("JKS", true),
    PKCS11("PKCS11", false),
    PKCS12("PKCS12", true),
    BKS("BKS", true),
    BCFKS("BCFKS", true);

    private final String m_sID;
    private final boolean m_bKeyStorePathRequired;

    private EKeyStoreType(String string2, boolean bl) {
        this.m_sID = string2;
        this.m_bKeyStorePathRequired = bl;
    }

    @Nonnull
    @Nonempty
    public String getID() {
        return this.m_sID;
    }

    @Override
    public boolean isKeyStorePathRequired() {
        return this.m_bKeyStorePathRequired;
    }

    @Nullable
    public static EKeyStoreType getFromIDOrNull(@Nullable String string) {
        return (EKeyStoreType)EnumHelper.getFromIDOrNull(EKeyStoreType.class, (Object)string);
    }

    @Nullable
    public static EKeyStoreType getFromIDCaseInsensitiveOrNull(@Nullable String string) {
        return (EKeyStoreType)EnumHelper.getFromIDCaseInsensitiveOrNull(EKeyStoreType.class, (String)string);
    }

    @Nullable
    public static EKeyStoreType getFromIDCaseInsensitiveOrDefault(@Nullable String string, @Nullable EKeyStoreType eKeyStoreType) {
        return (EKeyStoreType)EnumHelper.getFromIDCaseInsensitiveOrDefault(EKeyStoreType.class, (String)string, (Enum)eKeyStoreType);
    }
}

