/*
 * Decompiled with CFR 0.152.
 */
package com.helger.matrix;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.math.MathHelper;
import com.helger.commons.string.StringHelper;
import com.helger.matrix.CholeskyDecomposition;
import com.helger.matrix.EigenvalueDecomposition;
import com.helger.matrix.LUDecomposition;
import com.helger.matrix.QRDecomposition;
import com.helger.matrix.SingularValueDecomposition;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;

public class Matrix
implements ICloneable<Matrix>,
Serializable {
    private final double[][] m_aData;
    private final int m_nRows;
    private final int m_nCols;

    public Matrix(@Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.isGT0((int)n, (String)"Rows");
        ValueEnforcer.isGT0((int)n2, (String)"Cols");
        this.m_nRows = n;
        this.m_nCols = n2;
        this.m_aData = new double[n][n2];
    }

    public Matrix(@Nonnegative int n, @Nonnegative int n2, double d) {
        this(n, n2);
        for (int i = 0; i < n; ++i) {
            Arrays.fill(this.m_aData[i], d);
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    Matrix(@Nonnull double[][] dArray) {
        ValueEnforcer.notNull((Object)dArray, (String)"Other");
        ValueEnforcer.isGT0((int)dArray.length, (String)"rows");
        ValueEnforcer.isGT0((int)dArray[0].length, (String)"cols");
        this.m_nRows = dArray.length;
        this.m_nCols = dArray[0].length;
        for (int i = 0; i < this.m_nRows; ++i) {
            if (dArray[i].length == this.m_nCols) continue;
            throw new IllegalArgumentException("All rows must have the same length.");
        }
        this.m_aData = dArray;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    Matrix(@Nonnull double[][] dArray, @Nonnegative int n, @Nonnegative int n2) {
        ValueEnforcer.notNull((Object)dArray, (String)"Other");
        ValueEnforcer.isGT0((int)n, (String)"rows");
        ValueEnforcer.isGT0((int)n2, (String)"cols");
        ValueEnforcer.isTrue((dArray.length >= n ? 1 : 0) != 0, (String)"array is too short");
        for (int i = 0; i < n; ++i) {
            ValueEnforcer.isTrue((dArray[i].length >= n2 ? 1 : 0) != 0, (String)"All rows must have the same length.");
        }
        this.m_aData = dArray;
        this.m_nRows = n;
        this.m_nCols = n2;
    }

    public Matrix(@Nonnull double[] dArray, @Nonnegative int n) {
        this.m_nRows = n;
        int n2 = this.m_nCols = n != 0 ? dArray.length / n : 0;
        if (n * this.m_nCols != dArray.length) {
            throw new IllegalArgumentException("Array length must be a multiple of nRows.");
        }
        this.m_aData = new double[n][this.m_nCols];
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray2[j] = dArray[i + j * n];
            }
        }
    }

    @Nonnull
    public static Matrix constructWithCopy(@Nonnull double[][] dArray) {
        int n = dArray.length;
        int n2 = dArray[0].length;
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray2 = matrix.internalGetArray();
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2[i];
            if (dArray3.length != n2) {
                throw new IllegalArgumentException("All rows must have the same length.");
            }
            System.arraycopy(dArray3, 0, dArray4, 0, dArray3.length);
        }
        return matrix;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getClone() {
        Matrix matrix = new Matrix(this.m_nRows, this.m_nCols);
        double[][] dArray = matrix.m_aData;
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aData[i];
            double[] dArray3 = dArray[i];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
        }
        return matrix;
    }

    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public double[][] internalGetArray() {
        return this.m_aData;
    }

    @Nonnull
    @ReturnsMutableCopy
    public double[][] getArrayCopy() {
        double[][] dArray = new double[this.m_nRows][this.m_nCols];
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aData[i];
            double[] dArray3 = dArray[i];
            System.arraycopy(dArray2, 0, dArray3, 0, this.m_nCols);
        }
        return dArray;
    }

    @Nonnull
    public double[] getColumnPackedCopy() {
        double[] dArray = new double[this.m_nRows * this.m_nCols];
        for (int i = 0; i < this.m_nCols; ++i) {
            int n = i * this.m_nRows;
            for (int j = 0; j < this.m_nRows; ++j) {
                dArray[j + n] = this.m_aData[j][i];
            }
        }
        return dArray;
    }

    @Nonnull
    public double[] getRowPackedCopy() {
        double[] dArray = new double[this.m_nRows * this.m_nCols];
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray[i * this.m_nCols + j] = dArray2[j];
            }
        }
        return dArray;
    }

    @Nonnegative
    public int getRowDimension() {
        return this.m_nRows;
    }

    @Nonnegative
    public int getColumnDimension() {
        return this.m_nCols;
    }

    public boolean isSymmetrical() {
        return this.m_nRows == this.m_nCols;
    }

    public double get(@Nonnegative int n, @Nonnegative int n2) {
        return this.m_aData[n][n2];
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getMatrix(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4) {
        Matrix matrix = new Matrix(n2 - n + 1, n4 - n3 + 1);
        double[][] dArray = matrix.internalGetArray();
        for (int i = n; i <= n2; ++i) {
            double[] dArray2 = this.m_aData[i];
            double[] dArray3 = dArray[i - n];
            for (int j = n3; j <= n4; ++j) {
                dArray3[j - n3] = dArray2[j];
            }
        }
        return matrix;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getMatrix(@Nonnull int[] nArray, @Nonnull int[] nArray2) {
        Matrix matrix = new Matrix(nArray.length, nArray2.length);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            double[] dArray2 = this.m_aData[n];
            double[] dArray3 = dArray[i];
            for (int j = 0; j < nArray2.length; ++j) {
                dArray3[j] = dArray2[nArray2[j]];
            }
        }
        return matrix;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getMatrix(@Nonnegative int n, @Nonnegative int n2, @Nonnull int[] nArray) {
        Matrix matrix = new Matrix(n2 - n + 1, nArray.length);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            for (int j = n; j <= n2; ++j) {
                dArray[j - n][i] = this.m_aData[j][n3];
            }
        }
        return matrix;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix getMatrix(@Nonnull int[] nArray, @Nonnegative int n, @Nonnegative int n2) {
        Matrix matrix = new Matrix(nArray.length, n2 - n + 1);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            double[] dArray2 = this.m_aData[n3];
            double[] dArray3 = dArray[i];
            for (int j = n; j <= n2; ++j) {
                dArray3[j - n] = dArray2[j];
            }
        }
        return matrix;
    }

    public void set(@Nonnegative int n, @Nonnegative int n2, double d) {
        this.m_aData[n][n2] = d;
    }

    public void setMatrix(@Nonnegative int n, @Nonnegative int n2, @Nonnegative int n3, @Nonnegative int n4, @Nonnull Matrix matrix) {
        for (int i = n; i <= n2; ++i) {
            double[] dArray = this.m_aData[i];
            for (int j = n3; j <= n4; ++j) {
                dArray[j] = matrix.get(i - n, j - n3);
            }
        }
    }

    public void setMatrix(@Nonnull int[] nArray, @Nonnull int[] nArray2, @Nonnull Matrix matrix) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            double[] dArray = this.m_aData[n];
            for (int j = 0; j < nArray2.length; ++j) {
                dArray[nArray2[j]] = matrix.get(i, j);
            }
        }
    }

    public void setMatrix(@Nonnull int[] nArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull Matrix matrix) {
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = nArray[i];
            double[] dArray = this.m_aData[n3];
            for (int j = n; j <= n2; ++j) {
                dArray[j] = matrix.get(i, j - n);
            }
        }
    }

    public void setMatrix(@Nonnegative int n, @Nonnegative int n2, @Nonnull int[] nArray, @Nonnull Matrix matrix) {
        for (int i = n; i <= n2; ++i) {
            double[] dArray = this.m_aData[i];
            for (int j = 0; j < nArray.length; ++j) {
                int n3 = nArray[j];
                dArray[n3] = matrix.get(i - n, j);
            }
        }
    }

    @Nonnull
    @CheckReturnValue
    @ReturnsMutableCopy
    public Matrix transpose() {
        Matrix matrix = new Matrix(this.m_nCols, this.m_nRows);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray[j][i] = dArray2[j];
            }
        }
        return matrix;
    }

    public double norm1() {
        double d = 0.0;
        for (int i = 0; i < this.m_nCols; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.m_nRows; ++j) {
                d2 += MathHelper.abs((double)this.m_aData[j][i]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double norm2() {
        return new SingularValueDecomposition(this).norm2();
    }

    public double normInf() {
        double d = 0.0;
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray = this.m_aData[i];
            double d2 = 0.0;
            for (int j = 0; j < this.m_nCols; ++j) {
                d2 += MathHelper.abs((double)dArray[j]);
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    public double normF() {
        double d = 0.0;
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                d = MathHelper.hypot((double)d, (double)dArray[j]);
            }
        }
        return d;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix uminus() {
        Matrix matrix = new Matrix(this.m_nRows, this.m_nCols);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aData[i];
            double[] dArray3 = dArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray3[j] = -dArray2[j];
            }
        }
        return matrix;
    }

    private void _checkMatrixDimensions(@Nonnull Matrix matrix) {
        if (matrix.m_nRows != this.m_nRows) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (matrix.m_nCols != this.m_nCols) {
            throw new IllegalArgumentException("Matrix column dimensions must agree.");
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix plus(@Nonnull Matrix matrix) {
        this._checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m_nRows, this.m_nCols);
        double[][] dArray = matrix2.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aData[i];
            double[] dArray3 = matrix.m_aData[i];
            double[] dArray4 = dArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray4[j] = dArray2[j] + dArray3[j];
            }
        }
        return matrix2;
    }

    @Nonnull
    public Matrix plusEquals(@Nonnull Matrix matrix) {
        this._checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray = matrix.m_aData[i];
            double[] dArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                int n = j;
                dArray2[n] = dArray2[n] + dArray[j];
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix minus(@Nonnull Matrix matrix) {
        this._checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m_nRows, this.m_nCols);
        double[][] dArray = matrix2.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aData[i];
            double[] dArray3 = matrix.m_aData[i];
            double[] dArray4 = dArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray4[j] = dArray2[j] - dArray3[j];
            }
        }
        return matrix2;
    }

    @Nonnull
    public Matrix minusEquals(@Nonnull Matrix matrix) {
        this._checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray = matrix.m_aData[i];
            double[] dArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                int n = j;
                dArray2[n] = dArray2[n] - dArray[j];
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix arrayTimes(@Nonnull Matrix matrix) {
        this._checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m_nRows, this.m_nCols);
        double[][] dArray = matrix2.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aData[i];
            double[] dArray3 = matrix.m_aData[i];
            double[] dArray4 = dArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray4[j] = dArray2[j] * dArray3[j];
            }
        }
        return matrix2;
    }

    @Nonnull
    public Matrix arrayTimesEquals(@Nonnull Matrix matrix) {
        this._checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray = matrix.m_aData[i];
            double[] dArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                int n = j;
                dArray2[n] = dArray2[n] * dArray[j];
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix arrayRightDivide(@Nonnull Matrix matrix) {
        this._checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m_nRows, this.m_nCols);
        double[][] dArray = matrix2.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aData[i];
            double[] dArray3 = matrix.m_aData[i];
            double[] dArray4 = dArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray4[j] = dArray2[j] / dArray3[j];
            }
        }
        return matrix2;
    }

    @Nonnull
    public Matrix arrayRightDivideEquals(@Nonnull Matrix matrix) {
        this._checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray = matrix.m_aData[i];
            double[] dArray2 = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                int n = j;
                dArray2[n] = dArray2[n] / dArray[j];
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix arrayLeftDivide(@Nonnull Matrix matrix) {
        this._checkMatrixDimensions(matrix);
        Matrix matrix2 = new Matrix(this.m_nRows, this.m_nCols);
        double[][] dArray = matrix2.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = matrix.m_aData[i];
            double[] dArray3 = this.m_aData[i];
            double[] dArray4 = dArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray4[j] = dArray2[j] / dArray3[j];
            }
        }
        return matrix2;
    }

    @Nonnull
    public Matrix arrayLeftDivideEquals(@Nonnull Matrix matrix) {
        this._checkMatrixDimensions(matrix);
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray;
            double[] dArray2 = matrix.m_aData[i];
            double[] dArray3 = dArray = this.m_aData[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray3[j] = dArray2[j] / dArray[j];
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix times(double d) {
        Matrix matrix = new Matrix(this.m_nRows, this.m_nCols);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray2 = this.m_aData[i];
            double[] dArray3 = dArray[i];
            for (int j = 0; j < this.m_nCols; ++j) {
                dArray3[j] = d * dArray2[j];
            }
        }
        return matrix;
    }

    @Nonnull
    public Matrix timesEquals(double d) {
        for (int i = 0; i < this.m_nRows; ++i) {
            double[] dArray = this.m_aData[i];
            int n = 0;
            while (n < this.m_nCols) {
                int n2 = n++;
                dArray[n2] = dArray[n2] * d;
            }
        }
        return this;
    }

    @Nonnull
    @ReturnsMutableCopy
    public Matrix times(@Nonnull Matrix matrix) {
        if (matrix.m_nRows != this.m_nCols) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        Matrix matrix2 = new Matrix(this.m_nRows, matrix.m_nCols);
        double[][] dArray = matrix2.internalGetArray();
        double[] dArray2 = new double[this.m_nCols];
        for (int i = 0; i < matrix.m_nCols; ++i) {
            int n;
            for (n = 0; n < this.m_nCols; ++n) {
                dArray2[n] = matrix.m_aData[n][i];
            }
            for (n = 0; n < this.m_nRows; ++n) {
                double[] dArray3 = this.m_aData[n];
                double d = 0.0;
                for (int j = 0; j < this.m_nCols; ++j) {
                    d += dArray3[j] * dArray2[j];
                }
                dArray[n][i] = d;
            }
        }
        return matrix2;
    }

    @Nonnull
    @ReturnsMutableCopy
    public LUDecomposition lu() {
        return new LUDecomposition(this);
    }

    @Nonnull
    @ReturnsMutableCopy
    public QRDecomposition qr() {
        return new QRDecomposition(this);
    }

    @Nonnull
    @ReturnsMutableCopy
    public CholeskyDecomposition chol() {
        return new CholeskyDecomposition(this);
    }

    @Nonnull
    @ReturnsMutableCopy
    public SingularValueDecomposition svd() {
        return new SingularValueDecomposition(this);
    }

    @Nonnull
    @ReturnsMutableCopy
    public EigenvalueDecomposition eig() {
        return new EigenvalueDecomposition(this);
    }

    @Nonnull
    public Matrix solve(@Nonnull Matrix matrix) {
        if (this.m_nRows == this.m_nCols) {
            return this.lu().solve(matrix);
        }
        return this.qr().solve(matrix);
    }

    @Nonnull
    public Matrix solveTranspose(@Nonnull Matrix matrix) {
        return this.transpose().solve(matrix.transpose());
    }

    @Nonnull
    public Matrix inverse() {
        return this.solve(Matrix.identity(this.m_nRows, this.m_nRows));
    }

    public double det() {
        return this.lu().det();
    }

    public int rank() {
        return this.svd().rank();
    }

    public double cond() {
        return this.svd().cond();
    }

    public double trace() {
        double d = 0.0;
        int n = Math.min(this.m_nRows, this.m_nCols);
        for (int i = 0; i < n; ++i) {
            d += this.m_aData[i][i];
        }
        return d;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Matrix random(@Nonnegative int n, @Nonnegative int n2) {
        ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray2[j] = ((Random)threadLocalRandom).nextDouble();
            }
        }
        return matrix;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static Matrix identity(@Nonnegative int n, @Nonnegative int n2) {
        Matrix matrix = new Matrix(n, n2);
        double[][] dArray = matrix.internalGetArray();
        for (int i = 0; i < n; ++i) {
            double[] dArray2 = dArray[i];
            for (int j = 0; j < n2; ++j) {
                dArray2[j] = i == j ? 1.0 : 0.0;
            }
        }
        return matrix;
    }

    public void print(@Nonnull PrintWriter printWriter, @Nonnegative int n, @Nonnegative int n2) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setMinimumIntegerDigits(1);
        numberFormat.setMaximumFractionDigits(n2);
        numberFormat.setMinimumFractionDigits(n2);
        numberFormat.setGroupingUsed(false);
        this.print(printWriter, numberFormat, n + 2);
    }

    public void print(@Nonnull PrintWriter printWriter, @Nonnull NumberFormat numberFormat, @Nonnegative int n) {
        printWriter.println();
        for (int i = 0; i < this.m_nRows; ++i) {
            for (int j = 0; j < this.m_nCols; ++j) {
                String string = numberFormat.format(this.m_aData[i][j]);
                int n2 = Math.max(1, n - string.length());
                printWriter.print(StringHelper.getRepeated((char)' ', (int)n2));
                printWriter.print(string);
            }
            printWriter.println();
        }
        printWriter.println();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Matrix matrix = (Matrix)object;
        if (this.m_nRows != matrix.m_nRows || this.m_nCols != matrix.m_nCols) {
            return false;
        }
        for (int i = 0; i < this.m_nRows; ++i) {
            if (Arrays.equals(this.m_aData[i], matrix.m_aData[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator((Object)this).append(this.m_nRows).append(this.m_nCols);
        for (int i = 0; i < this.m_nRows; ++i) {
            hashCodeGenerator.append(this.m_aData[i]);
        }
        return hashCodeGenerator.getHashCode();
    }

    @Nonnull
    public static Matrix read(@Nonnull @WillNotClose Reader reader) throws IOException {
        int n;
        StreamTokenizer streamTokenizer = new StreamTokenizer(StreamHelper.getBuffered((Reader)reader));
        streamTokenizer.resetSyntax();
        streamTokenizer.wordChars(0, 255);
        streamTokenizer.whitespaceChars(0, 32);
        streamTokenizer.eolIsSignificant(true);
        while (streamTokenizer.nextToken() == 10) {
        }
        if (streamTokenizer.ttype == -1) {
            throw new IOException("Unexpected EOF on matrix read.");
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        do {
            commonsArrayList.add((Object)Double.valueOf(streamTokenizer.sval));
        } while (streamTokenizer.nextToken() == -3);
        int n2 = commonsArrayList.size();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = (Double)commonsArrayList.get(i);
        }
        CommonsArrayList commonsArrayList2 = new CommonsArrayList();
        commonsArrayList2.add((Object)dArray);
        while (streamTokenizer.nextToken() == -3) {
            dArray = new double[n2];
            commonsArrayList2.add((Object)dArray);
            n = 0;
            do {
                if (n >= n2) {
                    throw new IOException("Row " + commonsArrayList2.size() + " is too long.");
                }
                dArray[n++] = Double.parseDouble(streamTokenizer.sval);
            } while (streamTokenizer.nextToken() == -3);
            if (n >= n2) continue;
            throw new IOException("Row " + commonsArrayList2.size() + " is too short.");
        }
        n = commonsArrayList2.size();
        return new Matrix((double[][])commonsArrayList2.toArray((Object[])new double[n][]));
    }
}

