/*
 * Decompiled with CFR 0.152.
 */
package com.helger.json.parser.handler;

import com.helger.annotation.Nonempty;
import com.helger.annotation.concurrent.NotThreadSafe;
import com.helger.collection.stack.NonBlockingStack;
import com.helger.json.IJson;
import com.helger.json.IJsonCollection;
import com.helger.json.JsonArray;
import com.helger.json.JsonObject;
import com.helger.json.JsonValue;
import com.helger.json.parser.handler.IJsonParserHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

@NotThreadSafe
public class CollectingJsonParserHandler
implements IJsonParserHandler {
    private IJson m_aJson;
    private final NonBlockingStack<IJsonCollection> m_aStack = new NonBlockingStack();
    private final NonBlockingStack<String> m_aObjectName = new NonBlockingStack();

    private void _addToStackPeek(@Nonnull IJson iJson) {
        IJsonCollection iJsonCollection = (IJsonCollection)this.m_aStack.peek();
        if (iJsonCollection.isArray()) {
            iJsonCollection.getAsArray().add(iJson);
        } else {
            iJsonCollection.getAsObject().add((String)this.m_aObjectName.pop(), iJson);
        }
    }

    private void _addSimple(@Nonnull IJson iJson) {
        if (this.m_aJson == null) {
            this.m_aJson = iJson;
        } else {
            this._addToStackPeek(iJson);
        }
    }

    private void _addCollection(@Nonnull IJsonCollection iJsonCollection) {
        this._addSimple(iJsonCollection);
        this.m_aStack.push((Object)iJsonCollection);
    }

    @Override
    public void onWhitespace(@Nonnull @Nonempty String string) {
    }

    @Override
    public void onComment(@Nonnull String string) {
    }

    @Override
    public void onString(@Nonnull String string, @Nonnull String string2) {
        this._addSimple(JsonValue.create(string2));
    }

    @Override
    public void onNumber(@Nonnull String string, @Nonnull Number number) {
        this._addSimple(JsonValue.create(number));
    }

    @Override
    public void onFalse() {
        this._addSimple(JsonValue.FALSE);
    }

    @Override
    public void onTrue() {
        this._addSimple(JsonValue.TRUE);
    }

    @Override
    public void onNull() {
        this._addSimple(JsonValue.NULL);
    }

    @Override
    public void onArrayStart() {
        this._addCollection(new JsonArray());
    }

    @Override
    public void onArrayNextElement() {
    }

    @Override
    public void onArrayEnd() {
        this.m_aStack.pop();
    }

    @Override
    public void onObjectStart() {
        this._addCollection(new JsonObject());
    }

    @Override
    public void onObjectName(@Nonnull String string, @Nonnull String string2) {
        this.m_aObjectName.push((Object)string2);
    }

    @Override
    public void onObjectColon() {
    }

    @Override
    public void onObjectNextElement() {
    }

    @Override
    public void onObjectEnd() {
        this.m_aStack.pop();
    }

    @Nullable
    public IJson getJson() {
        return this.m_aJson;
    }
}

