/*
 * Decompiled with CFR 0.152.
 */
package com.helger.graph.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashMap;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsOrderedMap;
import com.helger.commons.collection.impl.ICommonsOrderedSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.state.EChange;
import com.helger.commons.state.ETriState;
import com.helger.commons.state.IChangeIndicator;
import com.helger.graph.IMutableDirectedGraph;
import com.helger.graph.IMutableDirectedGraphNode;
import com.helger.graph.IMutableDirectedGraphObjectFactory;
import com.helger.graph.IMutableDirectedGraphRelation;
import com.helger.graph.impl.AbstractBaseGraph;
import com.helger.graph.iterate.DirectedGraphIteratorForward;
import com.helger.matrix.Matrix;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class DirectedGraph
extends AbstractBaseGraph<IMutableDirectedGraphNode, IMutableDirectedGraphRelation>
implements IMutableDirectedGraph {
    private final IMutableDirectedGraphObjectFactory m_aFactory;
    private ETriState m_eCacheHasCycles = ETriState.UNDEFINED;

    public DirectedGraph(@Nullable String string, @Nonnull IMutableDirectedGraphObjectFactory iMutableDirectedGraphObjectFactory) {
        super(string);
        ValueEnforcer.notNull((Object)iMutableDirectedGraphObjectFactory, (String)"Factory");
        this.m_aFactory = iMutableDirectedGraphObjectFactory;
    }

    @Override
    public final boolean isDirected() {
        return true;
    }

    private void _invalidateCache() {
        this.m_eCacheHasCycles = ETriState.UNDEFINED;
    }

    @Override
    @Nonnull
    public IMutableDirectedGraphNode createNode() {
        IMutableDirectedGraphNode iMutableDirectedGraphNode = this.m_aFactory.createNode();
        if (this.addNode(iMutableDirectedGraphNode).isUnchanged()) {
            throw new IllegalStateException("The ID factory created the ID '" + (String)iMutableDirectedGraphNode.getID() + "' that is already in use");
        }
        return iMutableDirectedGraphNode;
    }

    @Override
    @Nullable
    public IMutableDirectedGraphNode createNode(@Nullable String string) {
        IMutableDirectedGraphNode iMutableDirectedGraphNode = this.m_aFactory.createNode(string);
        return this.addNode(iMutableDirectedGraphNode).isChanged() ? iMutableDirectedGraphNode : null;
    }

    @Override
    @Nonnull
    public EChange addNode(@Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        ValueEnforcer.notNull((Object)iMutableDirectedGraphNode, (String)"Node");
        if (!this.isChangingConnectedObjectsAllowed() && iMutableDirectedGraphNode.hasRelations()) {
            throw new IllegalArgumentException("The node to be added already has incoming and/or outgoing relations and this is not allowed!");
        }
        String string = (String)iMutableDirectedGraphNode.getID();
        if (this.m_aNodes.containsKey((Object)string)) {
            return EChange.UNCHANGED;
        }
        this.m_aNodes.put((Object)string, (Object)iMutableDirectedGraphNode);
        this._invalidateCache();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange removeNode(@Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        ValueEnforcer.notNull((Object)iMutableDirectedGraphNode, (String)"Node");
        if (!this.isChangingConnectedObjectsAllowed() && iMutableDirectedGraphNode.hasRelations()) {
            throw new IllegalArgumentException("The node to be removed already has incoming and/or outgoing relations and this is not allowed!");
        }
        if (this.m_aNodes.remove(iMutableDirectedGraphNode.getID()) == null) {
            return EChange.UNCHANGED;
        }
        this._invalidateCache();
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange removeNodeAndAllRelations(@Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode) {
        ValueEnforcer.notNull((Object)iMutableDirectedGraphNode, (String)"Node");
        if (!this.m_aNodes.containsKey(iMutableDirectedGraphNode.getID())) {
            return EChange.UNCHANGED;
        }
        for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation : iMutableDirectedGraphNode.getAllOutgoingRelations()) {
            ((IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getTo()).removeIncomingRelation(iMutableDirectedGraphRelation);
        }
        for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation : iMutableDirectedGraphNode.getAllIncomingRelations()) {
            ((IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getFrom()).removeOutgoingRelation(iMutableDirectedGraphRelation);
        }
        iMutableDirectedGraphNode.removeAllRelations();
        if (this.removeNode(iMutableDirectedGraphNode).isUnchanged()) {
            throw new IllegalStateException("Inconsistency removing node and all relations");
        }
        return EChange.CHANGED;
    }

    @Nonnull
    private IMutableDirectedGraphRelation _connect(@Nonnull IMutableDirectedGraphRelation iMutableDirectedGraphRelation) {
        ((IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getFrom()).addOutgoingRelation(iMutableDirectedGraphRelation);
        ((IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getTo()).addIncomingRelation(iMutableDirectedGraphRelation);
        this._invalidateCache();
        return iMutableDirectedGraphRelation;
    }

    @Override
    @Nonnull
    public IMutableDirectedGraphRelation createRelation(@Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode, @Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode2) {
        return this._connect(this.m_aFactory.createRelation(iMutableDirectedGraphNode, iMutableDirectedGraphNode2));
    }

    @Override
    @Nonnull
    public IMutableDirectedGraphRelation createRelation(@Nullable String string, @Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode, @Nonnull IMutableDirectedGraphNode iMutableDirectedGraphNode2) {
        return this._connect(this.m_aFactory.createRelation(string, iMutableDirectedGraphNode, iMutableDirectedGraphNode2));
    }

    @Override
    @Nonnull
    public EChange removeRelation(@Nullable IMutableDirectedGraphRelation iMutableDirectedGraphRelation) {
        EChange eChange = EChange.UNCHANGED;
        if (iMutableDirectedGraphRelation != null) {
            eChange = eChange.or((IChangeIndicator)((IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getFrom()).removeOutgoingRelation(iMutableDirectedGraphRelation));
            if ((eChange = eChange.or((IChangeIndicator)((IMutableDirectedGraphNode)iMutableDirectedGraphRelation.getTo()).removeIncomingRelation(iMutableDirectedGraphRelation))).isChanged()) {
                this._invalidateCache();
            }
        }
        return eChange;
    }

    @Override
    @Nonnull
    public IMutableDirectedGraphNode getSingleStartNode() {
        ICommonsSet<IMutableDirectedGraphNode> iCommonsSet = this.getAllStartNodes();
        if (iCommonsSet.size() > 1) {
            throw new IllegalStateException("Graph has more than one starting node");
        }
        if (iCommonsSet.isEmpty()) {
            throw new IllegalStateException("Graph has no starting node");
        }
        return (IMutableDirectedGraphNode)CollectionHelper.getFirstElement(iCommonsSet);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<IMutableDirectedGraphNode> getAllStartNodes() {
        return CollectionHelper.newSet((Collection)this.m_aNodes.values(), iMutableDirectedGraphNode -> !iMutableDirectedGraphNode.hasIncomingRelations());
    }

    @Override
    @Nonnull
    public IMutableDirectedGraphNode getSingleEndNode() {
        ICommonsSet<IMutableDirectedGraphNode> iCommonsSet = this.getAllEndNodes();
        if (iCommonsSet.size() > 1) {
            throw new IllegalStateException("Graph has more than one ending node");
        }
        if (iCommonsSet.isEmpty()) {
            throw new IllegalStateException("Graph has no ending node");
        }
        return (IMutableDirectedGraphNode)CollectionHelper.getFirstElement(iCommonsSet);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<IMutableDirectedGraphNode> getAllEndNodes() {
        return CollectionHelper.newSet((Collection)this.m_aNodes.values(), iMutableDirectedGraphNode -> !iMutableDirectedGraphNode.hasOutgoingRelations());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, IMutableDirectedGraphRelation> getAllRelations() {
        CommonsLinkedHashMap commonsLinkedHashMap = new CommonsLinkedHashMap();
        for (IMutableDirectedGraphNode iMutableDirectedGraphNode : this.m_aNodes.values()) {
            iMutableDirectedGraphNode.forEachRelation(arg_0 -> DirectedGraph.lambda$getAllRelations$2((ICommonsOrderedMap)commonsLinkedHashMap, arg_0));
        }
        return commonsLinkedHashMap;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IMutableDirectedGraphRelation> getAllRelationObjs() {
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (IMutableDirectedGraphNode iMutableDirectedGraphNode : this.m_aNodes.values()) {
            iMutableDirectedGraphNode.forEachRelation(arg_0 -> ((ICommonsList)commonsArrayList).add(arg_0));
        }
        return commonsArrayList;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllRelationIDs() {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet();
        for (IMutableDirectedGraphNode iMutableDirectedGraphNode : this.m_aNodes.values()) {
            commonsLinkedHashSet.addAll(iMutableDirectedGraphNode.getAllRelationIDs());
        }
        return commonsLinkedHashSet;
    }

    @Override
    public void forEachRelation(@Nonnull Consumer<? super IMutableDirectedGraphRelation> consumer) {
        ValueEnforcer.notNull(consumer, (String)"Consumer");
        for (IMutableDirectedGraphNode iMutableDirectedGraphNode : this.m_aNodes.values()) {
            iMutableDirectedGraphNode.forEachOutgoingRelation(consumer);
        }
    }

    @Nonnull
    public EChange removeAll() {
        if (this.m_aNodes.removeAll().isUnchanged()) {
            return EChange.UNCHANGED;
        }
        this._invalidateCache();
        return EChange.CHANGED;
    }

    @Override
    public boolean containsCycles() {
        if (this.m_eCacheHasCycles.isUndefined()) {
            this.m_eCacheHasCycles = ETriState.FALSE;
            for (IMutableDirectedGraphNode iMutableDirectedGraphNode : this.m_aNodes.values()) {
                DirectedGraphIteratorForward directedGraphIteratorForward = new DirectedGraphIteratorForward(iMutableDirectedGraphNode);
                while (directedGraphIteratorForward.hasNext() && !directedGraphIteratorForward.hasCycles()) {
                    directedGraphIteratorForward.next();
                }
                if (!directedGraphIteratorForward.hasCycles()) continue;
                this.m_eCacheHasCycles = ETriState.TRUE;
                break;
            }
        }
        return this.m_eCacheHasCycles.getAsBooleanValue(true);
    }

    @Override
    public boolean isSelfContained() {
        for (IMutableDirectedGraphNode iMutableDirectedGraphNode : this.m_aNodes.values()) {
            for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation : iMutableDirectedGraphNode.getAllIncomingRelations()) {
                if (this.m_aNodes.containsKey((Object)iMutableDirectedGraphRelation.getFromID())) continue;
                return false;
            }
            for (IMutableDirectedGraphRelation iMutableDirectedGraphRelation : iMutableDirectedGraphNode.getAllOutgoingRelations()) {
                if (this.m_aNodes.containsKey((Object)iMutableDirectedGraphRelation.getToID())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    @Nonnull
    public Matrix createIncidenceMatrix() {
        int n = this.getNodeCount();
        Matrix matrix = new Matrix(n, n, 0.0);
        IMutableDirectedGraphNode[] iMutableDirectedGraphNodeArray = this.m_aNodes.values().toArray(new IMutableDirectedGraphNode[n]);
        for (int i = 0; i < n; ++i) {
            IMutableDirectedGraphNode iMutableDirectedGraphNode = iMutableDirectedGraphNodeArray[i];
            for (int j = 0; j < n; ++j) {
                if (i == j || !iMutableDirectedGraphNode.isToNode(iMutableDirectedGraphNodeArray[j])) continue;
                matrix.set(i, j, 1.0);
                matrix.set(j, i, -1.0);
            }
        }
        return matrix;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static /* synthetic */ void lambda$getAllRelations$2(ICommonsOrderedMap iCommonsOrderedMap, IMutableDirectedGraphRelation iMutableDirectedGraphRelation) {
        iCommonsOrderedMap.put((Object)((String)iMutableDirectedGraphRelation.getID()), (Object)iMutableDirectedGraphRelation);
    }
}

